/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.unsafe;

import com.pingidentity.pingcommons.gcp.key.shade.javax.annotation.Nullable;
import io.grpc.Context;
import io.opencensus.trace.ContextHandle;
import io.opencensus.trace.ContextManager;
import io.opencensus.trace.Span;
import io.opencensus.trace.unsafe.ContextHandleImpl;
import io.opencensus.trace.unsafe.ContextUtils;

public class ContextManagerImpl
implements ContextManager {
    @Override
    public ContextHandle currentContext() {
        return ContextManagerImpl.wrapContext(Context.current());
    }

    @Override
    public ContextHandle withValue(ContextHandle contextHandle, @Nullable Span span) {
        return ContextManagerImpl.wrapContext(ContextUtils.withValue(ContextManagerImpl.unwrapContext(contextHandle), span));
    }

    @Override
    public Span getValue(ContextHandle contextHandle) {
        return ContextUtils.getValue(ContextManagerImpl.unwrapContext(contextHandle));
    }

    private static ContextHandle wrapContext(Context context) {
        return new ContextHandleImpl(context);
    }

    private static Context unwrapContext(ContextHandle contextHandle) {
        return ((ContextHandleImpl)contextHandle).getContext();
    }

    protected ContextManagerImpl() {
    }
}

