/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.Location;
import org.apache.hivemind.impl.ImplMessages;
import org.apache.hivemind.impl.TranslatorContribution;
import org.apache.hivemind.internal.RegistryInfrastructure;
import org.apache.hivemind.schema.Translator;
import org.apache.hivemind.schema.rules.ClassTranslator;
import org.apache.hivemind.schema.rules.InstanceTranslator;
import org.apache.hivemind.schema.rules.ServiceTranslator;
import org.apache.hivemind.schema.rules.SmartTranslator;

public class TranslatorManager {
    static final Log LOG = LogFactory.getLog((Class)(class$org$apache$hivemind$impl$TranslatorManager == null ? (class$org$apache$hivemind$impl$TranslatorManager = TranslatorManager.class$("org.apache.hivemind.impl.TranslatorManager")) : class$org$apache$hivemind$impl$TranslatorManager));
    public static final String TRANSLATORS_CONFIGURATION_ID = "hivemind.Translators";
    private ErrorHandler _errorHandler;
    private RegistryInfrastructure _registry;
    private Map _translatorClasses = new HashMap();
    private Map _translatorsCache = new HashMap();
    private boolean _translatorsLoaded;
    static /* synthetic */ Class class$org$apache$hivemind$impl$TranslatorManager;
    static /* synthetic */ Class class$org$apache$hivemind$schema$rules$SmartTranslator;
    static /* synthetic */ Class class$java$lang$String;

    public TranslatorManager(RegistryInfrastructure registry, ErrorHandler errorHandler) {
        this._registry = registry;
        this._errorHandler = errorHandler;
        this._translatorsCache.put("class", new ClassTranslator());
        this._translatorsCache.put("service", new ServiceTranslator());
        this._translatorsCache.put("smart", new SmartTranslator());
        this._translatorsCache.put("instance", new InstanceTranslator());
        this._translatorClasses.put("smart", class$org$apache$hivemind$schema$rules$SmartTranslator == null ? (class$org$apache$hivemind$schema$rules$SmartTranslator = TranslatorManager.class$("org.apache.hivemind.schema.rules.SmartTranslator")) : class$org$apache$hivemind$schema$rules$SmartTranslator);
    }

    public synchronized Translator getTranslator(String constructor) {
        Translator result;
        if (!this._translatorsLoaded && !this._translatorsCache.containsKey(constructor)) {
            this.loadTranslators();
        }
        if ((result = (Translator)this._translatorsCache.get(constructor)) == null) {
            result = this.constructTranslator(constructor);
            this._translatorsCache.put(constructor, result);
        }
        return result;
    }

    private Translator constructTranslator(String constructor) {
        String name = constructor;
        String initializer = null;
        int commax = constructor.indexOf(44);
        if (commax > 0) {
            name = constructor.substring(0, commax);
            initializer = constructor.substring(commax + 1);
        }
        Class translatorClass = this.findTranslatorClass(name);
        return this.createTranslator(translatorClass, initializer);
    }

    private Translator createTranslator(Class translatorClass, String initializer) {
        try {
            if (initializer == null) {
                return (Translator)translatorClass.newInstance();
            }
            Constructor c = translatorClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = TranslatorManager.class$("java.lang.String")) : class$java$lang$String);
            return (Translator)c.newInstance(initializer);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.translatorInstantiationFailure(translatorClass, ex), ex);
        }
    }

    private Class findTranslatorClass(String translatorName) {
        Class result = (Class)this._translatorClasses.get(translatorName);
        if (result == null) {
            throw new ApplicationRuntimeException(ImplMessages.unknownTranslatorName(translatorName, TRANSLATORS_CONFIGURATION_ID));
        }
        return result;
    }

    private void loadTranslators() {
        this._translatorsLoaded = true;
        List contributions = this._registry.getConfiguration(TRANSLATORS_CONFIGURATION_ID, null);
        HashMap<String, Location> locations = new HashMap<String, Location>();
        locations.put("class", null);
        Iterator i = contributions.iterator();
        while (i.hasNext()) {
            TranslatorContribution c = (TranslatorContribution)i.next();
            String name = c.getName();
            Location oldLocation = (Location)locations.get(name);
            if (oldLocation != null) {
                this._errorHandler.error(LOG, ImplMessages.duplicateTranslatorName(name, oldLocation), c.getLocation(), null);
                continue;
            }
            locations.put(name, c.getLocation());
            Translator t = c.getTranslator();
            if (t != null) {
                this._translatorsCache.put(name, t);
                continue;
            }
            Class tClass = c.getTranslatorClass();
            if (tClass == null) {
                this._errorHandler.error(LOG, ImplMessages.incompleteTranslator(c), c.getLocation(), null);
                continue;
            }
            this._translatorClasses.put(name, tClass);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

