/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.schema.rules;

import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Location;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.schema.Translator;
import org.apache.hivemind.schema.rules.RuleUtils;
import org.apache.hivemind.schema.rules.RulesMessages;

public class DoubleTranslator
implements Translator {
    private double _minValue;
    private boolean _isMinValue;
    private double _maxValue;
    private boolean _isMaxValue;
    private double _defaultValue = 0.0;

    public DoubleTranslator() {
    }

    public DoubleTranslator(String initializer) {
        String maxInit;
        String minInit;
        Map m = RuleUtils.convertInitializer(initializer);
        String defaultInit = (String)m.get("default");
        if (defaultInit != null) {
            this._defaultValue = Double.parseDouble(defaultInit);
        }
        if ((minInit = (String)m.get("min")) != null) {
            this._isMinValue = true;
            this._minValue = Double.parseDouble(minInit);
        }
        if ((maxInit = (String)m.get("max")) != null) {
            this._isMaxValue = true;
            this._maxValue = Double.parseDouble(maxInit);
        }
    }

    public Object translate(Module contributingModule, Class propertyType, String inputValue, Location location) {
        double value;
        if (HiveMind.isBlank(inputValue)) {
            return new Double(this._defaultValue);
        }
        try {
            value = Double.parseDouble(inputValue);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(RulesMessages.invalidDoubleValue(inputValue), location, ex);
        }
        if (this._isMinValue && value < this._minValue) {
            throw new ApplicationRuntimeException(RulesMessages.minDoubleValue(inputValue, this._minValue));
        }
        if (this._isMaxValue && value > this._maxValue) {
            throw new ApplicationRuntimeException(RulesMessages.maxDoubleValue(inputValue, this._maxValue));
        }
        return new Double(value);
    }
}

