/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.adapter.sp;

import com.pingidentity.adapter.virtual.VirtualAuthnAdapter;
import com.pingidentity.adapter.virtual.VirtualAuthnAdapterInstance;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.AuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.sp.authn.SpAuthenticationAdapter;
import org.sourceid.saml20.adapter.sp.authn.SsoContext;
import org.sourceid.saml20.adapter.state.ApplicationSessionStateSupport;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.internal.TransactionIdSupport;

public class LocalIdentityManagementAdapter
implements SpAuthenticationAdapter,
VirtualAuthnAdapter {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String ADAPTER_TYPE = "Profile Management SP Adapter";
    private static final String ADAPTER_ID_PREFIX = "idprofile";
    private String lipId = null;

    public void setAdapterId(String adapterId) {
        this.lipId = StringUtils.removeStart((String)adapterId, (String)ADAPTER_ID_PREFIX);
    }

    public Serializable createAuthN(SsoContext ssoContext, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        LocalIdentityManager manager = MgmtFactory.getLocalIdentityProfileManager();
        LocalIdentityProfile profile = manager.getProfile(this.lipId);
        if (profile == null) {
            this.log.error((Object)("There is not local identity profile with the ID " + this.lipId));
            throw new AuthnAdapterException("Authentication failed.");
        }
        try {
            DN dn = this.getDNFromSession(profile, req, resp);
            this.saveUserData(profile, dn, req, resp);
        }
        catch (LDAPException e) {
            this.log.error((Object)"Unable to get DN from session.");
            throw new AuthnAdapterException("Authentication failed", (Throwable)e);
        }
        req.setAttribute("create.authn.complete", (Object)true);
        String redirectURL = this.hasQueryParam(ssoContext.getTargetResourceUrl()) ? ssoContext.getTargetResourceUrl() + "&LocalIdentityProfileID=" + this.lipId : ssoContext.getTargetResourceUrl() + "?LocalIdentityProfileID=" + this.lipId;
        resp.sendRedirect(redirectURL);
        return "";
    }

    private boolean hasQueryParam(String targetResourceUrl) {
        return targetResourceUrl.contains("?");
    }

    private void saveUserData(LocalIdentityProfile profile, DN dn, HttpServletRequest req, HttpServletResponse resp) {
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        sessionStateSupport.setAttribute(profile.getProfileManagementSessionKey(), (Object)dn.toNormalizedString(), req, resp, false);
        sessionStateSupport.setAttribute(profile.getTransactionIdKey(), (Object)TransactionIdSupport.getTransactionId(), req, resp, false);
    }

    private DN getDNFromSession(LocalIdentityProfile localIdentityProfile, HttpServletRequest req, HttpServletResponse resp) throws LDAPException, AuthnAdapterException {
        String keyName;
        ApplicationSessionStateSupport sessionStateSupport = new ApplicationSessionStateSupport(localIdentityProfile.getId(), (arg_0, arg_1, arg_2) -> ((LocalIdentityProfile)localIdentityProfile).clearSession(arg_0, arg_1, arg_2));
        Object dnString = sessionStateSupport.removeAttribute(keyName = localIdentityProfile.getDnHandoffStateKey(), req, resp);
        if (dnString == null) {
            this.log.error((Object)"No DN was found to lookup the user for profile management.");
            throw new AuthnAdapterException("An error occurred.");
        }
        return new DN((String)dnString);
    }

    public Set<VirtualAuthnAdapterInstance> getAdapterInstances() {
        HashSet<VirtualAuthnAdapterInstance> instances = new HashSet<VirtualAuthnAdapterInstance>();
        LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
        for (LocalIdentityProfile lip : profileManager.getProfiles()) {
            String adapterIdAndName = ADAPTER_ID_PREFIX + lip.getId();
            VirtualAuthnAdapterInstance profileMgmtInstance = new VirtualAuthnAdapterInstance(adapterIdAndName, adapterIdAndName, Collections.singleton(lip.getContractId()));
            instances.add(profileMgmtInstance);
        }
        return instances;
    }

    public AuthnAdapterDescriptor getAdapterDescriptor() {
        return new AuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, ADAPTER_TYPE, null, false, null);
    }

    public String lookupLocalUserId(HttpServletRequest req, HttpServletResponse resp, String partnerIdpEntityId, String resumePath) throws AuthnAdapterException, IOException {
        return null;
    }

    public boolean logoutAuthN(Serializable authnBean, HttpServletRequest req, HttpServletResponse resp, String resumePath) throws AuthnAdapterException, IOException {
        LocalIdentityManager manager = MgmtFactory.getLocalIdentityProfileManager();
        LocalIdentityProfile localIdentityProfile = manager.getProfile(this.lipId);
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        localIdentityProfile.clearSession(sessionStateSupport, req, resp);
        return true;
    }

    public void configure(Configuration configuration) {
    }
}

