/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.common;

import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.locale.TemplateMessage;
import com.pingidentity.locale.TemplateMessageHolder;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.sdk.template.TemplateRendererUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.profiles.AdapterPathSupport;

public final class EmailTemplateRendererUtils {
    private EmailTemplateRendererUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static void renderEmailSentPage(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile localIdentityProfile, Map<String, Object> templateData) throws TemplateRendererUtilException {
        String emailVerificationSentTemplateName = localIdentityProfile.getEmailOwnershipVerificationConfig().getEmailVerificationSentTemplateName();
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)emailVerificationSentTemplateName, templateData);
    }

    public static void renderEmailVerificationOtpPage(HttpServletRequest req, HttpServletResponse resp, String email, LocalIdentityProfile localIdentityProfile, TemplateBannerMessage bannerMessage, Map<String, Object> templateData) throws TemplateRendererUtilException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String emailVerificationSentTemplateName = localIdentityProfile.getEmailOwnershipVerificationConfig().getEmailVerificationOtpTemplateName();
        params.put("cSRFToken", CrossSiteRequestForgeryHelper.getCSRFToken((HttpServletRequest)req, (HttpServletResponse)resp));
        if (StringUtils.isNotBlank((String)email)) {
            params.put("emailSentTo", email);
        }
        params.putAll(templateData);
        params.put("url", AdapterPathSupport.convertPath((HttpServletRequest)req, (HttpServletResponse)resp, (String)LocalIdentityUtils.getSendEmailVerificationPathWithLipId((String)localIdentityProfile.getId())));
        params.put("otpVerification", "pf.otp.email.verify.otp");
        params.put("sendEmailVerification", "pf.otp.email.send");
        params.put("ok", "pf.ok");
        params.put("cancel", "pf.cancel");
        params.put("isProfileManagementEnabled", localIdentityProfile.isProfileEnabled());
        if (localIdentityProfile.isProfileEnabled()) {
            params.put("profileManagement", "pf.otp.email.profileManagement");
            params.put("profileManagementPath", LocalIdentityUtils.getProfileManagementPathWithLipId((String)localIdentityProfile.getId()));
        }
        if (bannerMessage != null) {
            TemplateMessageHolder bannerMessages = new TemplateMessageHolder();
            bannerMessages.addMessage((TemplateMessage)bannerMessage);
            params.put("bannerMessages", bannerMessages);
        }
        TemplateRendererUtil.render((HttpServletRequest)req, (HttpServletResponse)resp, (String)emailVerificationSentTemplateName, params);
    }

    public static void renderEmailVerificationErrorPage(HttpServletRequest request, HttpServletResponse response, LocalIdentityProfile lip, String titleKey, String messageKey, Map<String, Object> templateData) throws TemplateRendererUtilException {
        String emailVerificationErrorTemplateName = lip.getEmailOwnershipVerificationConfig().getEmailVerificationErrorTemplateName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", titleKey);
        params.put("errorMessageKey", messageKey);
        if (templateData != null) {
            params.putAll(templateData);
        }
        TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)emailVerificationErrorTemplateName, params);
    }

    public static void renderEmailVerificationSuccessPage(HttpServletRequest request, HttpServletResponse response, LocalIdentityProfile lip, Map<String, Object> templateData) throws TemplateRendererUtilException {
        String emailVerificationSuccessTemplateName = lip.getEmailOwnershipVerificationConfig().getEmailVerificationSuccessTemplateName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(templateData);
        TemplateRendererUtil.render((HttpServletRequest)request, (HttpServletResponse)response, (String)emailVerificationSuccessTemplateName, params);
    }
}

