/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.common;

import com.pingidentity.locale.StandardTemplateMessage;
import com.pingidentity.localidentity.ConnectedIdentity;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.authsource.LocalAccountAuthSource;
import com.pingidentity.localidentity.authsource.LocalIdentityAuthSource;
import com.pingidentity.localidentity.common.ConnectedIdentityUtils;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.unboundid.ldap.sdk.DN;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.data.FieldData;
import org.sourceid.saml20.adapter.state.SessionStateSupport;

public final class LocalIdentityStorageUtils {
    private static final Log log = LogFactory.getLog(LocalIdentityStorageUtils.class);

    private LocalIdentityStorageUtils() {
        throw new AssertionError((Object)"not allowed");
    }

    public static LocalIdentityDTO<DN> retrieveUserData(LocalIdentityProfile lip, DN dn) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager manager = lip.getStorageManager();
        try {
            return manager.getIdentityByDn(lip, dn);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Could not find a user with the DN '" + dn.toNormalizedString() + "'."));
            throw e;
        }
    }

    public static void deleteUser(LocalIdentityProfile localIdentityProfile, DN userDN, HttpServletRequest req, HttpServletResponse resp) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager localIdentityStorageManager = localIdentityProfile.getStorageManager();
        localIdentityStorageManager.deleteIdentity(localIdentityProfile, userDN);
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        localIdentityProfile.clearSession(sessionStateSupport, req, resp);
    }

    public static LocalIdentityDTO<DN> updateUser(LocalIdentityProfile localIdentityProfile, DN dtoIdentifier, Map<String, FieldData<?>> updatedAttributes) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException, ModifyIdentityException {
        LocalIdentityStorageManager localIdentityStorageManager = localIdentityProfile.getStorageManager();
        LocalIdentityField uniqueIdField = localIdentityProfile.getFieldConfig().getUniqueIdField();
        String uniqueIdFieldId = uniqueIdField.getData().getId();
        if (updatedAttributes.containsKey(uniqueIdFieldId)) {
            String uniqueId = (String)updatedAttributes.get(uniqueIdFieldId).getFirstValue();
            uniqueId = LocalIdentityUtils.getFormattedUniqueId((LocalIdentityProfile)localIdentityProfile, (String)uniqueId);
            if (localIdentityStorageManager.identityExists(localIdentityProfile, LocalAccountAuthSource.PF_LOCAL_ACCOUNT_AUTH_SOURCE.getId(), uniqueId)) {
                String[] params = new String[]{uniqueId};
                StandardTemplateMessage errorMessage = new StandardTemplateMessage("local.identity.profile.unique.id.exists", params);
                String message = uniqueId + " is in use, please try another value.";
                throw new ModifyIdentityException(message, errorMessage);
            }
        }
        return localIdentityStorageManager.updateIdentity(localIdentityProfile, dtoIdentifier, updatedAttributes);
    }

    public static LocalIdentityDTO<DN> updatePassword(LocalIdentityProfile lip, DN dto, String currentPassword, String newPassword) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager localIdentityStorageManager = lip.getStorageManager();
        return localIdentityStorageManager.changePassword(lip, dto, currentPassword, newPassword);
    }

    public static LocalIdentityDTO<DN> setPassword(LocalIdentityProfile lip, DN dto, String password) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager localIdentityStorageManager = lip.getStorageManager();
        return localIdentityStorageManager.setPassword(lip, dto, password);
    }

    public static void disconnectIdentity(String authSourceId, LocalIdentityDTO<DN> dto, LocalIdentityProfile profile) throws DisconnectIdentityException {
        LocalIdentityStorageManager storageManager = profile.getStorageManager();
        LocalIdentityAuthSource authSource = profile.getAuthSourceById(authSourceId);
        DN identifier = (DN)dto.getIdentifier();
        try {
            if (!dto.hasPassword() && dto.getConnectedIdentities().size() <= 2) {
                String error = authSource.getSource() + " is the only method to login to this local identity. Cannot disconnect this identity from " + identifier + " until another login method is connected or a local password is set.";
                log.warn((Object)error);
                String[] params = new String[]{authSource.getSource()};
                StandardTemplateMessage errorMessage = new StandardTemplateMessage("local.identity.profile.disconnectNotAllowed", params);
                throw new DisconnectIdentityException.LastConnectedIdentityException(error, errorMessage);
            }
            ConnectedIdentity identity = ConnectedIdentityUtils.findConnectedIdentity(authSourceId, dto);
            if (identity != null) {
                String identityAuthSourceId = identity.getAuthSourceId();
                String userId = identity.getUserId();
                storageManager.removeConnectedIdentity(profile, identifier, identityAuthSourceId, userId);
            }
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            String error = String.format("Disconnecting user '%s' from the auth source '%s' failed due to %s", identifier, authSource.getSource(), e.getMessage());
            log.error((Object)error);
            log.debug((Object)error, (Throwable)e);
            String[] params = new String[]{authSource.getSource()};
            StandardTemplateMessage errorMessage = new StandardTemplateMessage("local.identity.profile.disconnectError", params);
            throw new DisconnectIdentityException(e.getMessage(), errorMessage);
        }
    }

    public static class DisconnectIdentityException
    extends Exception {
        private final StandardTemplateMessage messageWrapper;

        DisconnectIdentityException(String message, StandardTemplateMessage messageWrapper) {
            super(message);
            this.messageWrapper = messageWrapper;
        }

        public StandardTemplateMessage getMessageWrapper() {
            return this.messageWrapper;
        }

        private static class LastConnectedIdentityException
        extends DisconnectIdentityException {
            LastConnectedIdentityException(String message, StandardTemplateMessage messageWrapper) {
                super(message, messageWrapper);
            }
        }
    }

    public static class ModifyIdentityException
    extends Exception {
        private final StandardTemplateMessage messageWrapper;

        ModifyIdentityException(String message, StandardTemplateMessage messageWrapper) {
            super(message);
            this.messageWrapper = messageWrapper;
        }

        public StandardTemplateMessage getMessageWrapper() {
            return this.messageWrapper;
        }
    }
}

