/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.handler;

import com.pingidentity.locale.TemplateBannerMessage;
import com.pingidentity.localidentity.LocalIdentityAuditLogger;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.common.EmailFieldUtils;
import com.pingidentity.localidentity.common.EmailTemplateRendererUtils;
import com.pingidentity.localidentity.common.JwtUtils;
import com.pingidentity.localidentity.handler.BaseLipHandler;
import com.pingidentity.localidentity.type.LocalIdentityValidationResult;
import com.unboundid.ldap.sdk.DN;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.localidentity.SendEmailVerification;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;

public class VerifyEmailHandler
extends BaseLipHandler {
    private static final Log log = LogFactory.getLog(VerifyEmailHandler.class);
    private static final String OTP_EMAIL_VERIFICATION_PREFIX = "local.identity.email.verification.otp.";

    public void handle(HttpServletRequest req, HttpServletResponse resp, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto, AttributeMap attributeMap) {
        LocalIdentityValidationResult localIdentityValidationResult;
        HashMap<String, Object> templateData = new HashMap<String, Object>();
        Map attributesForMapping = dto != null ? dto.getAttributesForMapping() : new HashMap();
        templateData.put("userAttributes", attributesForMapping);
        if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip) && !EmailFieldUtils.isEmailStatusVerified(lip, dto)) {
            try {
                if (!"POST".equals(req.getMethod())) {
                    resp.sendError(405);
                    return;
                }
                if (this.isCSRFCheckRequired(req) && !this.isCSRFValid(req, resp)) {
                    return;
                }
            }
            catch (IOException e) {
                log.error((Object)("Error occurred on " + LocalIdentityUtils.getVerifyEmailPath() + ": " + e.getLocalizedMessage()));
                return;
            }
            localIdentityValidationResult = LocalIdentityUtils.validateOtp((HttpServletRequest)req, (HttpServletResponse)resp, (String)attributeMap.getSingleValue("oneTimePasscode"), (LocalIdentityProfile)lip, dto);
        } else {
            localIdentityValidationResult = this.validateJwt(attributeMap, lip, dto);
        }
        try {
            if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.Expired) {
                if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip)) {
                    TemplateBannerMessage bannerMessage = new TemplateBannerMessage(OTP_EMAIL_VERIFICATION_PREFIX + localIdentityValidationResult.getErrorKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR);
                    EmailTemplateRendererUtils.renderEmailVerificationOtpPage(req, resp, SendEmailVerification.getEmail((LocalIdentityProfile)lip, (Map)attributesForMapping), lip, bannerMessage, templateData);
                } else {
                    EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "expired.link.title", "expired.link", templateData);
                }
                return;
            }
            if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.Invalid) {
                if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip)) {
                    TemplateBannerMessage bannerMessage = new TemplateBannerMessage(OTP_EMAIL_VERIFICATION_PREFIX + localIdentityValidationResult.getErrorKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR);
                    EmailTemplateRendererUtils.renderEmailVerificationOtpPage(req, resp, SendEmailVerification.getEmail((LocalIdentityProfile)lip, (Map)attributesForMapping), lip, bannerMessage, templateData);
                } else {
                    EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "invalid.link.title", "invalidLink", templateData);
                }
                return;
            }
            if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.TooManyAttempts) {
                if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip)) {
                    EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "title", localIdentityValidationResult.getErrorKey(), templateData);
                }
                return;
            }
            if (localIdentityValidationResult.getValidationResultType() == LocalIdentityValidationResult.ValidationResultType.Error) {
                if (LocalIdentityUtils.isOtpEmailVerificationType((LocalIdentityProfile)lip)) {
                    TemplateBannerMessage bannerMessage = new TemplateBannerMessage(OTP_EMAIL_VERIFICATION_PREFIX + localIdentityValidationResult.getErrorKey(), null, TemplateBannerMessage.TemplateMessageType.ERROR);
                    EmailTemplateRendererUtils.renderEmailVerificationOtpPage(req, resp, SendEmailVerification.getEmail((LocalIdentityProfile)lip, (Map)attributesForMapping), lip, bannerMessage, templateData);
                }
                return;
            }
            if (!EmailFieldUtils.isEmailStatusVerified(lip, dto)) {
                dto = this.updateUserVerifyEmailStatus(lip, dto);
            }
            LocalIdentityAuditLogger.init((LocalIdentityAuditLogger.LocalIdentityAuditEvent)LocalIdentityAuditLogger.LocalIdentityAuditEvent.EMAIL_ADDRESS_VERIFY, dto, (LocalIdentityProfile)lip, null, (HttpServletRequest)req, (HttpServletResponse)resp);
            LocalIdentityAuditLogger.log();
            EmailTemplateRendererUtils.renderEmailVerificationSuccessPage(req, resp, lip, templateData);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)String.format("Error occurred on %s trying to update the email verify status in LDAP.", LocalIdentityUtils.getVerifyEmailPath()));
            try {
                EmailTemplateRendererUtils.renderEmailVerificationErrorPage(req, resp, lip, "authFailed", "emailVerificationFailed", templateData);
            }
            catch (Exception ex) {
                log.error((Object)("Error rendering the email verification error template for " + LocalIdentityUtils.getVerifyEmailPath()));
            }
        }
        catch (IOException ex) {
            log.error((Object)String.format("Error occurred on %s: %s", LocalIdentityUtils.getVerifyEmailPath(), ex.getLocalizedMessage()));
        }
    }

    private LocalIdentityValidationResult validateJwt(AttributeMap attrs, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto) {
        log.debug((Object)"Validating JWT for local identity.");
        if (attrs == null || attrs.isEmpty()) {
            log.debug((Object)"Invalid token. No attributes found in jwt token.");
            return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Invalid);
        }
        return this.validateJwtClaims((Map<String, AttributeValue>)attrs, lip, dto);
    }

    private LocalIdentityValidationResult validateJwtClaims(Map<String, AttributeValue> attrs, LocalIdentityProfile lip, LocalIdentityDTO<DN> dto) {
        AttributeMap refAttributes = new AttributeMap(attrs);
        if (!lip.getId().equals(JwtUtils.getLipIdFromAttributeMap(refAttributes))) {
            log.debug((Object)"Local Identity Profile for session doesn't match the one in JWT.");
            return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Invalid);
        }
        try {
            if (EmailFieldUtils.isExpired(refAttributes, lip)) {
                log.debug((Object)"Token has expired");
                return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Expired);
            }
        }
        catch (ParseException ex) {
            return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Expired);
        }
        if (!EmailFieldUtils.isValidEmail(lip, dto, refAttributes)) {
            log.debug((Object)"Invalid Link: Email mismatch");
            return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Invalid);
        }
        return new LocalIdentityValidationResult(LocalIdentityValidationResult.ValidationResultType.Success);
    }
}

