/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.localidentity.servlet;

import com.pingidentity.common.util.OtpUtils;
import com.pingidentity.localidentity.LocalIdentityAdapter;
import com.pingidentity.localidentity.LocalIdentityDTO;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.LocalIdentityUtils;
import com.pingidentity.localidentity.common.JwtUtils;
import com.pingidentity.localidentity.handler.ProfileHandler;
import com.pingidentity.localidentity.handler.SendEmailHandler;
import com.pingidentity.localidentity.handler.VerifyEmailHandler;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.util.QueryParams;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.localidentity.LocalIdentityStorageManager;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.state.ApplicationSessionStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.token.PFInternalTokenTranslator;
import org.sourceid.token.jwt.JwtTokenGeneratorImpl;
import org.sourceid.token.jwt.PFInternalTokenException;
import org.sourceid.token.jwt.PFLocalIdentityToJwtTranslator;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.util.log.internal.TransactionIdSupport;
import org.sourceid.websso.servlet.EnforcerServletBase;
import org.sourceid.websso.servlet.localidentity.LipHandler;
import org.sourceid.websso.servlet.localidentity.LipHandlerRegistry;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class LocalIdentityManagementServlet
extends EnforcerServletBase {
    private static final Log log = LogFactory.getLog(LocalIdentityManagementServlet.class);
    private final MetadataLocal metadataLocal = MetaDataFactory.getLocalMetaData();

    public void init() {
        log.info((Object)"Initializing...");
        LipHandlerRegistry.registerHandler((String)LocalIdentityUtils.getProfileManagementPath(), (LipHandler)new ProfileHandler(), (boolean)false);
        LipHandlerRegistry.registerHandler((String)LocalIdentityUtils.getSendEmailVerificationPath(), (LipHandler)new SendEmailHandler(), (boolean)false);
        LipHandlerRegistry.registerHandler((String)LocalIdentityUtils.getVerifyEmailPath(), (LipHandler)new VerifyEmailHandler(), (boolean)true);
    }

    public void process(HttpServletRequest req, HttpServletResponse resp, boolean isPost) throws IOException {
        LocalIdentityDTO<DN> dto;
        String lipId;
        String jwt = this.getJwt(req);
        String otp = this.getOtp(req);
        AttributeMap attributes = null;
        if (StringUtils.isNotBlank((String)jwt)) {
            try {
                req.removeAttribute("LocalIdentityProfileID");
                attributes = new AttributeMap(this.getJwtAttributeMap(jwt));
                lipId = JwtUtils.getLipIdFromAttributeMap(attributes);
            }
            catch (InvalidRequestParameterException e) {
                log.error((Object)"Invalid jwt request.");
                resp.sendError(404);
                return;
            }
        } else if (otp != null) {
            attributes = new AttributeMap();
            attributes.put("oneTimePasscode", otp);
            lipId = req.getParameter("LocalIdentityProfileID");
        } else {
            lipId = req.getParameter("LocalIdentityProfileID");
        }
        LocalIdentityProfile lip = this.getLocalIdentityProfile(resp, lipId);
        if (lip == null) {
            return;
        }
        LipHandler handler = LipHandlerRegistry.getHandler((String)req.getServletPath(), (boolean)this.isAuthenticated(req, jwt, otp));
        if (!(handler instanceof ProfileHandler || handler instanceof SendEmailHandler || handler instanceof VerifyEmailHandler)) {
            log.error((Object)"No matching handler found to handle the process.");
            resp.sendError(404);
            return;
        }
        if (handler instanceof VerifyEmailHandler || handler instanceof SendEmailHandler) {
            if (lip.getEmailOwnershipVerificationConfig() != null && !lip.getEmailOwnershipVerificationConfig().isEmailVerificationEnabled()) {
                log.error((Object)String.format("The local identity profile '%s' does not have email verification turned on.", lip.getId()));
                resp.sendError(404);
                return;
            }
        } else if (handler instanceof ProfileHandler && !lip.isProfileEnabled()) {
            log.error((Object)String.format("The local identity profile '%s' does not have profile management turned on.", lip.getId()));
            resp.sendError(404);
            return;
        }
        try {
            dto = this.getSessionAttributes(lip, req, resp);
        }
        catch (AuthnAdapterException e) {
            log.debug((Object)"Unable to retrieve session attributes.");
            resp.sendError(503);
            return;
        }
        if (dto != null) {
            handler.handle(req, resp, lip, dto, attributes);
        } else {
            this.redirectToStartSSO(req, resp, lip.getId(), jwt);
        }
    }

    private LocalIdentityProfile getLocalIdentityProfile(HttpServletResponse resp, String lipId) throws IOException {
        LocalIdentityProfile lip = null;
        if (StringUtils.isBlank((String)lipId)) {
            log.error((Object)"No local identity profile ID specified. Please pass in a populated parameter 'LocalIdentityProfileID'.");
            resp.sendError(400);
        } else {
            LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
            lip = profileManager.getProfile(lipId);
            if (lip == null) {
                log.error((Object)String.format("The local identity profile '%s' could not be found.", lipId));
                resp.sendError(404);
            }
        }
        return lip;
    }

    private void redirectToStartSSO(HttpServletRequest req, HttpServletResponse resp, String lipId, String jwt) throws IOException {
        Object targetResource = this.hasQueryParam(this.getTargetResource(req)) ? (StringUtils.isBlank((String)jwt) ? this.getTargetResource(req) : this.getTargetResource(req) + "&localidentity.a=" + jwt) : (StringUtils.isBlank((String)jwt) ? this.getTargetResource(req) : this.getTargetResource(req) + "?localidentity.a=" + jwt);
        QueryParams queryParams = new QueryParams(req);
        queryParams.put("SpSessionAuthnAdapterId", "idprofile" + lipId);
        queryParams.put("TargetResource", (String)targetResource);
        Object redirectString = "/sp/startSSO.ping?" + queryParams.getQueryParamString();
        redirectString = AdapterPathSupport.convertPath((HttpServletRequest)req, (HttpServletResponse)resp, (String)redirectString);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Received manage profile request. Redirecting to '%s'", redirectString));
        }
        resp.sendRedirect((String)redirectString);
    }

    private boolean hasQueryParam(String targetResourceUrl) {
        return targetResourceUrl.contains("?");
    }

    private LocalIdentityDTO<DN> getSessionAttributes(LocalIdentityProfile profile, HttpServletRequest req, HttpServletResponse resp) throws AuthnAdapterException {
        Object dnObj;
        ApplicationSessionStateSupport sessionStateSupport = new ApplicationSessionStateSupport(profile.getId(), (arg_0, arg_1, arg_2) -> ((LocalIdentityProfile)profile).clearSession(arg_0, arg_1, arg_2));
        Object transactionIdObj = sessionStateSupport.getAttribute(profile.getTransactionIdKey(), req, resp);
        if (transactionIdObj instanceof String) {
            TransactionIdSupport.setTransactionId((String)((String)transactionIdObj));
        }
        if ((dnObj = sessionStateSupport.getAttribute(profile.getProfileManagementSessionKey(), req, resp)) != null) {
            try {
                DN dn = new DN((String)dnObj);
                return this.retrieveUserData(profile, dn);
            }
            catch (LDAPException e) {
                log.error((Object)("Could not create a valid DN from saved session value '" + dnObj + "'."));
                log.debug((Object)e.getLocalizedMessage());
                throw new AuthnAdapterException("Authentication Failed.", (Throwable)e);
            }
            catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
                log.error((Object)("Could not retrieve user data for '" + dnObj + "'."));
                log.debug((Object)e.getLocalizedMessage());
                throw new AuthnAdapterException("Authentication Failed.", (Throwable)e);
            }
        }
        return null;
    }

    private LocalIdentityDTO<DN> retrieveUserData(LocalIdentityProfile profile, DN dn) throws LocalIdentityStorageManager.LocalIdentityStorageManagementException {
        LocalIdentityStorageManager manager = profile.getStorageManager();
        try {
            return manager.getIdentityByDn(profile, dn);
        }
        catch (LocalIdentityStorageManager.LocalIdentityStorageManagementException e) {
            log.error((Object)("Could not find a user with the DN '" + dn.toNormalizedString() + "'."));
            throw e;
        }
    }

    private String getTargetResource(HttpServletRequest request) {
        return BaseUrlUtil.getCurrentBaseUrl((String)(this.metadataLocal.getBaseUrl() + request.getServletPath()));
    }

    private String getJwtReferenceId(HttpServletRequest req) {
        return req.getParameter("localidentity.a");
    }

    private Map<String, AttributeValue> getJwtAttributeMap(String referenceId) {
        Map attrs;
        JwtTokenGeneratorImpl tokenGenerator = new JwtTokenGeneratorImpl((PFInternalTokenTranslator)new PFLocalIdentityToJwtTranslator());
        try {
            attrs = tokenGenerator.decrypt(referenceId);
        }
        catch (PFInternalTokenException e) {
            throw new InvalidRequestParameterException(e.getMessage());
        }
        return attrs;
    }

    private String getJwt(HttpServletRequest req) {
        return this.getJwtReferenceId(req);
    }

    private boolean isAuthenticated(HttpServletRequest req, String jwt, String otp) {
        if (LocalIdentityAdapter.isOtpVerifiedEmailPosted((HttpServletRequest)req)) {
            if (LocalIdentityAdapter.isResendAction((HttpServletRequest)req) || LocalIdentityAdapter.isCancelAction((HttpServletRequest)req)) {
                return false;
            }
            return otp != null && LocalIdentityAdapter.isContinueAction((HttpServletRequest)req);
        }
        return StringUtils.isNotBlank((String)jwt);
    }

    private String getOtp(HttpServletRequest req) {
        return OtpUtils.getOtp((HttpServletRequest)req);
    }
}

