/**
 * The Groovy extensions to support Attribute Mapping Language (AML).
 */
import com.pingconnect.saas.attribute.*;
import com.pingconnect.saas.attribute.transform.impl.*



class Aml {

    // build the target SAML attribute
    static SamlAttributeValue target(){new SamlAttributeValue()}
       
    // build the target JSON attribute 
    static JsonAttributeValue json(Object... args) {
        def result = new JsonAttributeValue();
        def jsonBuilder = new groovy.json.JsonBuilder(); 
        jsonBuilder(args); 
        result.setValue(jsonBuilder.toString());
        return result;
    }
    
    // parse the value as a JSON object that can be navigated using GPath 
    static Object jsonp(SamlAttributeValue value) {
        return new groovy.json.JsonSlurper().parseText(value.toString());
    }
}

def mc = new ExpandoMetaClass(SamlAttributeValue, false, true)
mc.initialize()

// bind the transformer functions to SamlAttributeValue
mc.methodMissing = {String function, args ->
     // Intercept method 
        transfomer = TransformerManager.getTransformer(function)
        
        if (transfomer) {
           SourceElement ruleElement = new SourceElement()
           ruleElement.setSourceType(SourceType.SOURCE_TYPE_ATTRIBUTE)
           ruleElement.setFunction(function)
           if (args.length > 0) {
               ruleElement.setExpression(args[0])
           }                    
           transfomer.transform(ruleElement, delegate)
        } else {
            throw new MissingMethodException(function, this.class, args)
        }     
}

// use the regex to extract the values from the source to build the target
mc.find = {String regex ->
     delegate."extractByRegularExpression"(regex)
}

// if the regex matches, return the source attribute
mc.match = {String regex ->
     delegate."filterByRegularExpression"(regex)
}

// overload the plug operation to allow two SamlAttributeValue to be concatenated as two strings.
mc.plus = {SamlAttributeValue other ->
    Concatenate.combineValues(TargetValueType.PLAIN_STRING, [delegate, other], false);
}

// overload the plug operation to allow two SamlAttributeValue to be concatenated with a string.
mc.plus = {String other ->
    Concatenate.combineValues(TargetValueType.PLAIN_STRING, [delegate, new SamlAttributeValue(other)], false);
}

// append one SamlAttributeValue to another to build a new one, with optional parameters to control the target value type
mc.add = {SamlAttributeValue other, TargetValueType targetType = TargetValueType.PLAIN_STRING, boolean isTargetMultiValued=true ->
    Concatenate.combineValues(TargetValueType.PLAIN_STRING, [delegate, other], isTargetMultiValued);
}

// append string to a SamlAttributeValue to build a new one, with optional parameters to control the target value type
mc.add = {String other, TargetValueType targetType = TargetValueType.PLAIN_STRING, boolean isTargetMultiValued=true ->
    Concatenate.combineValues(TargetValueType.PLAIN_STRING, [delegate, new SamlAttributeValue(other)], isTargetMultiValued);
}

// parse the source attribute value as JSON object for GPath navigation
mc.json = {->Aml.jsonp(delegate)}

// attach the metadata class to SamlAttributeValue
SamlAttributeValue.metaClass = mc

// attach the transformer functions into String so we can apply single value transformation to any string
String.metaClass.methodMissing = {String function, args ->
     // Intercept method 
        transfomer = TransformerManager.getTransformer(function)
        
        if (transfomer) {
           SourceElement ruleElement = new SourceElement()
           ruleElement.setSourceType(SourceType.SOURCE_TYPE_ATTRIBUTE)
           ruleElement.setFunction(function)
           if (args.length > 0) {
               ruleElement.setExpression(args[0])
           }                    
           // notice we put the delegate, which is a String into a SamlAttribute
           transfomer.transform(ruleElement, new SamlAttributeValue(delegate))
        } else {
            throw new MissingMethodException(function, this.class, args)
        }     
}

// build a target SamlAttributeValue
binding.target={->Aml.target()}

// build a target JsonAttributeValue
binding.json={Object... args->Aml.json(args)}

