#!/usr/bin/env sh

DIRNAME=$(dirname "$0")/..
DIRNAME=$(cd "$DIRNAME" && pwd)
DIRNAME_ESC=$(echo "$DIRNAME" | sed 's/ /%20/g')
DEFAULT_DIR="$DIRNAME/server/default"
DEFAULT_DATA="$DEFAULT_DIR/data"
PF_ROOT=$(cd "$(dirname "$0")/.." && pwd)

cd "$PF_ROOT" || exit

LIB=lib

PF_ENDORSED_DIRS=$LIB/endorsed

if [ -z "$RUN_CONF" ]; then
  RUN_CONF="$DIRNAME/bin/run.conf"
fi
if [ -r "$RUN_CONF" ]; then
  # shellcheck source=/dev/null
  . "$RUN_CONF"
fi

CLASSPATH="$DIRNAME/bin/pf-consoleutils.jar"
CLASSPATH="$CLASSPATH:$DIRNAME/bin/pf-startup.jar"
CLASSPATH="$CLASSPATH:$DEFAULT_DIR/lib/*"
CLASSPATH="$CLASSPATH:$PF_ROOT/lib/*"
CLASSPATH="$CLASSPATH:$DEFAULT_DIR/deploy/*"
CLASSPATH="$CLASSPATH:$DEFAULT_DIR/conf/"
CLASSPATH="$CLASSPATH:$DEFAULT_DIR/conf/generated-hivemodule/"

if [ ! -d log ]; then
  mkdir log
fi

if [ -z "$JAVA" ]; then
  if [ -n "$JAVA_HOME" ]; then
    JAVA="$JAVA_HOME/bin/java"
  else
    JAVA="java"
    echo "JAVA_HOME is not set.  Unexpected results may occur."
    echo "Set JAVA_HOME to the directory of your local JDK to avoid this message."
  fi
fi

JAVA_VERSION=$("$JAVA" -version 2>&1 | grep "version" | head -n 1 | cut -d\" -f 2)
JAVA_MAJOR_VERSION=$(echo "${JAVA_VERSION}" | sed 's/_/./g' | cut -d. -f 1)

ENDORSED_DIRS_FLAG=""
if [ "$JAVA_MAJOR_VERSION" = "1" ]; then
  ENDORSED_DIRS_FLAG='-Djava.endorsed.dirs='"$PF_ENDORSED_DIRS"
fi

runprops="$PF_ROOT/bin/run.properties"
if [ ! -f "$runprops" ]; then
  echo "Missing run.properties; using defaults."
  runprops=""
fi

JAVA_OPTS=""
if [ "$JAVA_MAJOR_VERSION" -eq 17 ] || [ "$JAVA_MAJOR_VERSION" -eq 21 ]; then
  JAVA_OPTS="$JAVA_OPTS --add-opens=java.base/java.lang=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-opens=java.base/java.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.x509=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.naming/com.sun.jndi.ldap=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.net.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.pkcs=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.pkcs10=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.internal.spec=ALL-UNNAMED"
fi

# shellcheck disable=SC2086
"$JAVA" \
  $JAVA_OPTS \
  -cp "$CLASSPATH" \
  $ENDORSED_DIRS_FLAG \
  -Dpf.home="$PF_ROOT" \
  -Dpf.server.default.dir="$DEFAULT_DIR" \
  -Dpf.server.data.dir="$DEFAULT_DATA" \
  -Dlog4j.configurationFile="file:///$DIRNAME_ESC/bin/provmgr.log4j2.xml" \
  -Drun.properties="$runprops" \
  com.pingidentity.provisioner.cli.CommandLineTool "$@"
