#!/usr/bin/env sh
### ====================================================================== ###
##                                                                          ##
## PingFederate Startup Script                                              ##
##                                                                          ##
### ====================================================================== ###

DIRNAME=$(dirname "$0")

# Setup PF_HOME
if [ -z "$PF_HOME" ]; then
  PF_HOME=$(cd "$DIRNAME/.." && pwd)
fi
export PF_HOME

if [ -z "$JAVA_HOME" ] || ! [ -x "$JAVA_HOME/bin/java" ]; then
  echo "No executable java found in JAVA_HOME for the user '$USER', please correct and start PingFederate again. Exiting."
  exit 1
fi

JAVA_VERSION_STRING=$("$JAVA_HOME/bin/java" -version 2>&1 | head -1 | cut -d '"' -f2)
javaSupportedVersion=0

case "$JAVA_VERSION_STRING" in
11 | 11.* | 17 | 17.* | 21 | 21.*) # Supported java versions
  javaSupportedVersion=1
  ;;
*) # other java versions
  javaSupportedVersion=0
  ;;
esac

if [ $javaSupportedVersion -eq 0 ]; then
  echo ""
  echo "!! WARNING !!"
  echo "Java version ${JAVA_VERSION_STRING} is not supported for running PingFederate. Please install Java 11, 17 or 21"
  echo ""
fi

# Create log folder
LOG_FOLDER="$PF_HOME/log"
if [ ! -d "$LOG_FOLDER" ]; then
  mkdir "${LOG_FOLDER}"
fi
# Console output files.
STDOUT_FILE="$PF_HOME/log/stdout.log"
STDERR_FILE="$PF_HOME/log/stderr.log"
# Check for currently running instance of PingFederate
RUNFILE="$PF_HOME/bin/pingfederate.pid"
if [ ! -e "$RUNFILE" ]; then
  touch "$RUNFILE"
  chmod 664 "$RUNFILE"
fi
# STDOUT
if [ ! -e "$STDOUT_FILE" ]; then
  touch "$STDOUT_FILE"
  chmod 664 "$STDOUT_FILE"
fi
# STDERR
if [ ! -e "$STDERR_FILE" ]; then
  touch "$STDERR_FILE"
  chmod 664 "$STDERR_FILE"
fi

CURRENT_PID=$(cat "$RUNFILE")
if [ -n "$CURRENT_PID" ]; then
  if kill -0 "$CURRENT_PID" 2>/dev/null; then
    echo "Another PingFederate instance with pid $CURRENT_PID is already running. Exiting."
    exit 1
  fi
fi

# Generate jvm-memory.options if it doesn't exist or has been deleted
if [ ! -f "$PF_HOME/bin/jvm-memory.options" ] && [ -f "$PF_HOME/bin/memoryoptions.sh" ]; then
  /usr/bin/env sh "$PF_HOME/bin/memoryoptions.sh"
fi

# Execute the run.sh script
echo "PingFederate is starting ..."
/usr/bin/env sh "$PF_HOME/bin/run.sh" 1>"$STDOUT_FILE" 2>"$STDERR_FILE" &
status=$?
exit $status
