#!/usr/bin/env sh
### ====================================================================== ###
##                                                                          ##
##  PingFederate Shutdown Script                                            ##
##                                                                          ##
### ====================================================================== ###

DIRNAME=$(dirname "$0")

# Setup PF_HOME
if [ -z "$PF_HOME" ]; then
  PF_HOME=$(
    cd "$DIRNAME/.." || exit
    pwd
  )
fi

# Check for currently running instance of PingFederate
RUNFILE="$PF_HOME/bin/pingfederate.pid"

if [ ! -e "$RUNFILE" ]; then
  echo "PingFederate is not currently running. Exiting."
  exit 0
fi

CURRENT_PID=$(cat "$RUNFILE")

if [ -n "$CURRENT_PID" ]; then

  if ! kill -0 "$CURRENT_PID" 2>/dev/null; then
    echo "PingFederate is not currently running. Exiting."
    exit 0
  fi

  if kill "$CURRENT_PID" 2>/dev/null; then
    echo -n "The PingFederate server is shutting down . . ."

    while ps "$CURRENT_PID" 1>/dev/null 2>/dev/null; do
      echo -n " ."
      sleep 1
    done

    echo " done."
    exit 0
  else
    echo "Unable to shutdown currently running PingFederate server. Exiting."
    exit 1
  fi
else
  echo "PingFederate is not currently running. Exiting."
  exit 0
fi
