#!/usr/bin/env sh
### ====================================================================== ###
##                                                                          ##
## PingFederate Status Check Script                                         ##
##                                                                          ##
### ====================================================================== ###

DIRNAME=$(dirname "$0")

PF_IS_RUNNING_MSG="PingFederate is running"
PF_IS_STOPPED_MSG="PingFederate is stopped"

# Setup PF_HOME
if [ -z "$PF_HOME" ]; then
  # get the full path (without any relative bits)
  PF_HOME=$(
    cd "$DIRNAME/.." || exit
    pwd
  )
fi
export PF_HOME

# Check for currently running instance of PingFederate
RUNFILE="$PF_HOME/bin/pingfederate.pid"

if [ ! -e "$RUNFILE" ]; then
  /bin/echo "$PF_IS_STOPPED_MSG"
  exit 0
fi

CURRENT_PID=$(cat "$RUNFILE")
if [ -n "$CURRENT_PID" ]; then
  if ! kill -0 "${CURRENT_PID}" 2>/dev/null; then
    /bin/echo "${PF_IS_STOPPED_MSG}"
    exit 0
  else
    /bin/echo "${PF_IS_RUNNING_MSG}"
    exit 1
  fi
else
  /bin/echo "$PF_IS_STOPPED_MSG"
  exit 0
fi
