#!/usr/bin/env sh

DIRNAME=$(dirname "$0")/..
DIRNAME=$(cd "$DIRNAME" && pwd)
# Set DIRNAME_ESC - this is DIRNAME but with spaces that are replaced with %20
DIRNAME_ESC=$(echo "$DIRNAME" | sed 's/ /%20/g')
PROGNAME=$(basename "$0")

PF_HOME=$(cd "$DIRNAME/.." && pwd)

#
# Helper to complain.
#
warn() {
  echo "${PROGNAME}: $*"
}

#
# Helper to fail.
#
die() {
  warn "$@"
  exit 1
}

# Setup the JVM
if [ -z "$JAVA" ]; then
  if [ -n "$JAVA_HOME" ]; then
    JAVA="$JAVA_HOME/bin/java"
    echo
  else
    JAVA="java"
    warn "JAVA_HOME is not set.  Please set the JAVA_HOME environment variable to a JDK directory path."
    exit 1
  fi
fi

# check java version
JAVA_VERSION_STRING=$("$JAVA" -version 2>&1 | head -1 | cut -d '"' -f2)
javaSupportedVersion=0

case "$JAVA_VERSION_STRING" in
11 | 11.* | 17 | 17.* | 21 | 21.*) # Supported java versions
  javaSupportedVersion=1
  ;;
*) # Unsupported java versions
  javaSupportedVersion=0
  ;;
esac

if [ "$javaSupportedVersion" -eq 0 ]; then
  echo ""
  echo "!! WARNING !!"
  echo "Java version ${JAVA_VERSION_STRING} is not supported for running PingFederate. Please install Java 11, 17 or 21"
  echo ""
fi

# Setup the classpath
pfrunjar="$PF_HOME/bin/pf-startup.jar"
if [ ! -f "$pfrunjar" ]; then
  die "Missing required file: $pfrunjar"
fi

CLASSPATH="$DIRNAME/lib/*:$pfrunjar:$PF_HOME/server/default/lib/*"

# java 17 support
JAVA_MAJOR_VERSION=$(echo "$JAVA_VERSION_STRING" | cut -d. -f1)
if [ "$JAVA_MAJOR_VERSION" -eq 17 ] || [ "$JAVA_MAJOR_VERSION" -eq 21 ]; then
  JAVA_OPTS="$JAVA_OPTS --add-opens=java.base/java.lang=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-opens=java.base/java.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.x509=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.naming/com.sun.jndi.ldap=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.net.util=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.pkcs=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.pkcs10=ALL-UNNAMED"
  JAVA_OPTS="$JAVA_OPTS --add-exports=java.base/sun.security.internal.spec=ALL-UNNAMED"
fi

# shellcheck disable=SC2086
"$JAVA" \
  -Xms128m -Xmx128m \
  $JAVA_OPTS \
  -Dupgrade.home.dir="$DIRNAME" \
  -Dlog.dir="$DIRNAME/log" \
  -Dlog4j.configurationFile="file:///$DIRNAME_ESC/bin/log4j2.xml" \
  -cp "$CLASSPATH" com.pingidentity.pingfederate.migration.UpgradeUtility "$@"
