
/*
 * Copyright 2024-2025 Ping Identity Corporation
 * All Rights Reserved.
 * ca69161d184e5b33dba94ea4ef9079a85d8265b087a7715ee39dbb14c321477a
 */
function openTab(evt, backendName) {
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(backendName).style.display = "block";
    evt.currentTarget.className += " active";
}

function switchTable(evt, tableType) {
    var allTables, activeTables, tableLinks;
    allTables = document.getElementsByClassName("styled-table");
    for (i = 0; i < allTables.length; i++) {
        allTables[i].style.display = "none";
    }
    tableLinks = document.getElementsByClassName("tableLinks");
    for (i = 0; i < tableLinks.length; i++) {
        tableLinks[i].className = tableLinks[i].className.replace(" active", "");
    }
    activeTables = document.querySelectorAll('[id*="' + tableType + '"]');
    for (i = 0; i < activeTables.length; i++) {
        activeTables[i].style.display = "";
    }
    evt.currentTarget.className += " active";
}

// Get the element with id="defaultOpen" and click on it
document.getElementById("defaultOpen").click();

