/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLEngine_9;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLEngineUtil {
    SSLEngineUtil() {
    }

    static ProvSSLEngine create(ContextData contextData) {
        return new ProvSSLEngine_9(contextData);
    }

    static ProvSSLEngine create(ContextData contextData, String host, int port) {
        return new ProvSSLEngine_9(contextData, host, port);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sslEngine) {
        SSLSession sslSession;
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getBCHandshakeSession();
        }
        if (null != sslEngine && null != (sslSession = sslEngine.getHandshakeSession())) {
            return SSLSessionUtil.importSSLSession(sslSession);
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sslEngine) {
        if (sslEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sslEngine)).getParameters();
        }
        if (null == sslEngine) {
            return null;
        }
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        if (null == sslParameters) {
            throw new RuntimeException("SSLEngine.getSSLParameters returned null");
        }
        return SSLParametersUtil.importSSLParameters(sslParameters);
    }
}

