/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.Manifest;
import com.unboundid.common.util.FileDigest;
import com.unboundid.common.util.FileUtils;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;

public class FileRecord {
    private static final Logger LOG = Logger.getLogger(FileRecord.class.getName());
    private static final String DEFAULT_DIGEST_ALGORITHM = "MD5";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CKSUM = "checksum";
    private static final String ATTR_LENGTH = "length";
    private static final String ATTR_MOD = "modified";
    private static final String ATTR_DIGEST_ALGORITHM = "digest-algorithm";
    private String relativePath;
    private Type type;
    private String checksum;
    private Long length;
    private Long lastModified;
    private String digestAlgorithm;

    public static FileRecord fromFile(File file, File root, FileDigest digest, Set<Manifest.Option> options) {
        Validator.ensureNotNull((Object)file, (Object)root, (Object)digest);
        FileRecord f = new FileRecord();
        if (options == null) {
            options = Collections.emptySet();
        }
        f.relativePath = FileRecord.normalizePath(FileUtils.getRelativePath(file, root));
        Type type = f.type = file.isFile() ? Type.FILE : Type.DIRECTORY;
        if (!options.contains((Object)Manifest.Option.PATHS_AND_TYPES_ONLY)) {
            f.length = file.length();
            f.lastModified = file.lastModified();
            if (file.isFile()) {
                try {
                    f.digestAlgorithm = digest.getDigestAlgorithm();
                    f.checksum = digest.hexStringForFile(file);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Error calculating checksum for " + file.getPath(), ioe);
                }
            }
        }
        return f;
    }

    static FileRecord fromAttributes(Attributes attrs) {
        String sMod;
        String sLength;
        FileRecord fileRecord = new FileRecord();
        fileRecord.relativePath = attrs.getValue(ATTR_PATH);
        fileRecord.checksum = attrs.getValue(ATTR_CKSUM);
        fileRecord.digestAlgorithm = attrs.getValue(ATTR_DIGEST_ALGORITHM);
        String sType = attrs.getValue(ATTR_TYPE);
        if (sType != null) {
            try {
                fileRecord.type = Type.valueOf(sType.toUpperCase());
                if (fileRecord.type == Type.FILE && fileRecord.digestAlgorithm == null) {
                    fileRecord.digestAlgorithm = DEFAULT_DIGEST_ALGORITHM;
                }
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, "Illegal value " + sType + " for " + ATTR_TYPE + " attribute");
            }
        }
        if ((sLength = attrs.getValue(ATTR_LENGTH)) != null) {
            try {
                fileRecord.length = Long.valueOf(sLength);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, "Illegal value " + sLength + " for " + ATTR_LENGTH + " attribute");
            }
        }
        if ((sMod = attrs.getValue(ATTR_MOD)) != null) {
            try {
                fileRecord.lastModified = Long.valueOf(sMod);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.WARNING, "Illegal value " + sMod + " for " + ATTR_MOD + " attribute");
            }
        }
        return fileRecord;
    }

    static String normalizePath(String path) {
        if (path == null) {
            path = "";
        }
        if ((path = path.replaceAll("\\\\", "/")).startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 2);
        }
        return path;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Type getType() {
        return this.type;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Long getLength() {
        return this.length;
    }

    public Date getLastModified() {
        if (this.lastModified != null) {
            return new Date(this.lastModified);
        }
        return null;
    }

    public void writeElement(XMLStreamWriter writer) throws XMLStreamException {
        this.writeElement(writer, Collections.emptySet());
    }

    public void writeElement(XMLStreamWriter writer, Set<Manifest.Option> options) throws XMLStreamException {
        if (options == null) {
            options = Collections.emptySet();
        }
        writer.writeStartElement("file");
        writer.writeAttribute(ATTR_PATH, this.relativePath);
        writer.writeAttribute(ATTR_TYPE, this.type.toString().toLowerCase());
        if (!options.contains((Object)Manifest.Option.PATHS_AND_TYPES_ONLY)) {
            if (this.checksum != null) {
                writer.writeAttribute(ATTR_CKSUM, this.checksum);
                writer.writeAttribute(ATTR_DIGEST_ALGORITHM, this.digestAlgorithm);
            }
            if (this.length != null) {
                writer.writeAttribute(ATTR_LENGTH, Long.toString(this.length));
            }
            if (this.lastModified != null) {
                writer.writeAttribute(ATTR_MOD, Long.toString(this.lastModified));
            }
        }
        writer.writeEndElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("path:").append(this.relativePath);
        if (this.type != null) {
            sb.append(" type:").append(this.type.toString().toLowerCase());
        }
        if (this.checksum != null) {
            sb.append(" checksum:").append(this.checksum);
        }
        if (this.digestAlgorithm != null) {
            sb.append(" digest-algorithm:").append(this.digestAlgorithm);
        }
        if (this.length != null) {
            sb.append(" length:").append(this.length);
        }
        if (this.lastModified != null) {
            sb.append(" modified:").append(new Date(this.lastModified));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileRecord)) {
            return false;
        }
        FileRecord that = (FileRecord)o;
        return !((this.checksum == null ? that.checksum != null : !this.checksum.equals(that.checksum)) || (this.digestAlgorithm == null ? that.digestAlgorithm != null : !this.digestAlgorithm.equals(that.digestAlgorithm)) || (this.lastModified == null ? that.lastModified != null : !this.lastModified.equals(that.lastModified)) || (this.length == null ? that.length != null : !this.length.equals(that.length)) || (this.relativePath == null ? that.relativePath != null : !this.relativePath.equals(that.relativePath)) || this.type != that.type);
    }

    public int hashCode() {
        int result = this.relativePath != null ? this.relativePath.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        result = 31 * result + (this.digestAlgorithm != null ? this.digestAlgorithm.hashCode() : 0);
        result = 31 * result + (this.length != null ? this.length.hashCode() : 0);
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        return result;
    }

    static enum Type {
        FILE,
        DIRECTORY;

    }
}

