/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.FileRecord;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Manifest {
    private Map<String, FileRecord> fileRecords = new HashMap<String, FileRecord>();

    Manifest() {
    }

    public Manifest(Set<FileRecord> fileRecords) {
        this.setFileRecords(fileRecords);
    }

    public Set<FileRecord> getFileRecords() {
        return Collections.unmodifiableSet(new HashSet<FileRecord>(this.fileRecords.values()));
    }

    public FileRecord getFileRecordForPath(String path) {
        return this.fileRecords.get(FileRecord.normalizePath(path));
    }

    void setFileRecords(Set<FileRecord> fileRecords) {
        if (fileRecords != null) {
            for (FileRecord fileRecord : fileRecords) {
                this.fileRecords.put(fileRecord.getRelativePath(), fileRecord);
            }
        } else {
            this.fileRecords = Collections.emptyMap();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Manifest)) {
            return false;
        }
        Manifest manifest = (Manifest)o;
        return !(this.fileRecords == null ? manifest.fileRecords != null : !this.fileRecords.equals(manifest.fileRecords));
    }

    public int hashCode() {
        return this.fileRecords != null ? this.fileRecords.hashCode() : 0;
    }

    public static enum Option {
        PATHS_AND_TYPES_ONLY;

    }
}

