/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.FileRecord;
import com.unboundid.common.manifest.Manifest;
import com.unboundid.common.util.FileDigest;
import com.unboundid.common.util.FileUtils;
import com.unboundid.common.util.tools.PBKDF2WithHmacSHA256FileDigest;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;

public class ManifestGenerator {
    private Set<Manifest.Option> options = new HashSet<Manifest.Option>();

    public static Manifest createFromRoot(File dir) {
        ManifestGenerator generator = new ManifestGenerator();
        return generator.create(dir);
    }

    public Manifest create(File root) {
        try {
            return this.create(root, "MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public Manifest create(File root, String digestAlgorithm) throws NoSuchAlgorithmException {
        FileDigest checkSum = digestAlgorithm.equalsIgnoreCase("PBKDF2WithHmacSHA256") ? new PBKDF2WithHmacSHA256FileDigest() : new FileDigest(digestAlgorithm);
        Set<FileRecord> records = this.readRecords(root, checkSum);
        return new Manifest(records);
    }

    public void setPathsAndTypesOnly(boolean filePathsOnly) {
        if (filePathsOnly) {
            this.options.add(Manifest.Option.PATHS_AND_TYPES_ONLY);
        } else {
            this.options.remove((Object)Manifest.Option.PATHS_AND_TYPES_ONLY);
        }
    }

    private Set<FileRecord> readRecords(File root, FileDigest checkSum) {
        HashSet<FileRecord> fileRecords = new HashSet<FileRecord>();
        this.readRecords(root, root, checkSum, fileRecords);
        return fileRecords;
    }

    private void readRecords(File file, File root, FileDigest checksum, Set<FileRecord> records) {
        if (file != null) {
            for (File child : FileUtils.listFiles(file)) {
                this.readRecords(child, root, checksum, records);
            }
            records.add(FileRecord.fromFile(file, root, checksum, this.options));
        }
    }
}

