/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.manifest;

import com.unboundid.common.manifest.FileRecord;
import com.unboundid.common.manifest.Manifest;
import com.unboundid.common.manifest.ManifestGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ManifestWriter {
    private Set<Manifest.Option> options = new HashSet<Manifest.Option>();
    private Manifest manifest;

    public static void writeToFile(File dir, File xmlFile) throws XMLStreamException, FileNotFoundException {
        ManifestGenerator generator = new ManifestGenerator();
        Manifest manifest = generator.create(dir);
        ManifestWriter writer = new ManifestWriter(manifest);
        writer.write(xmlFile);
    }

    public ManifestWriter(Manifest manifest) {
        this.manifest = manifest;
    }

    public void setPathsAndTypesOnly(boolean filePathsOnly) {
        if (filePathsOnly) {
            this.options.add(Manifest.Option.PATHS_AND_TYPES_ONLY);
        } else {
            this.options.remove((Object)Manifest.Option.PATHS_AND_TYPES_ONLY);
        }
    }

    public void write(File output) throws XMLStreamException, FileNotFoundException {
        try {
            ByteArrayOutputStream writerOutput = new ByteArrayOutputStream();
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = factory.createXMLStreamWriter(writerOutput);
            writer.writeStartDocument("1.0");
            writer.writeStartElement("root");
            for (FileRecord fileRecord : this.manifest.getFileRecords()) {
                fileRecord.writeElement(writer, this.options);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            ByteArrayInputStream writerOutputInput = new ByteArrayInputStream(writerOutput.toByteArray());
            FileOutputStream fileOutput = new FileOutputStream(output);
            StreamResult result = new StreamResult(fileOutput);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new StreamSource(writerOutputInput), result);
            fileOutput.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

