/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.platform;

import java.util.EnumSet;

public enum JavaRuntime {
    JAVA_SE("Java(TM) SE Runtime Environment"),
    OPEN_JDK("OpenJDK Runtime Environment");

    private final String name;

    public static JavaRuntime current() {
        return JavaRuntime.valueOfString(System.getProperty("java.runtime.name"));
    }

    public static JavaRuntime valueOfString(String name) {
        for (JavaRuntime runtime : EnumSet.allOf(JavaRuntime.class)) {
            if (!runtime.name.toLowerCase().equals(name.toLowerCase())) continue;
            return runtime;
        }
        throw new IllegalArgumentException("Unknown runtime " + name);
    }

    public String getName() {
        return this.name;
    }

    private JavaRuntime(String name) {
        this.name = name;
    }
}

