/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.platform;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.platform.JavaRuntime;
import com.unboundid.common.platform.JavaVendor;
import com.unboundid.common.platform.JavaVersion;
import com.unboundid.common.platform.PlatformSupport;
import com.unboundid.messages.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JavaSupportMatrix {
    public static final String MINIMUM_SUFFIX = "minimum";
    public static final String PREFERRED_SUFFIX = "preferred";
    public static final String SUPPRESS_UNRECOGNIZED_WARNINGS = "SUPPRESS_UNRECOGNIZED_WARNINGS";
    public static final String SUPPRESS_UNRECOGNIZED_WARNINGS_PROPERTY = "com.unboundid.common.platform.SuppressUnrecognizedWarnings";
    private Map<String, String> matrix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSupportMatrix(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(propertiesFile);
            properties.load(fis);
            this.setMatrix(properties);
        }
    }

    public JavaSupportMatrix(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setMatrix(properties);
    }

    public JavaSupportMatrix(Properties properties) {
        this.setMatrix(properties);
    }

    JavaSupportMatrix(Map<String, String> matrix) {
        Properties p = new Properties();
        p.putAll(matrix);
        this.setMatrix(p);
    }

    public String toString() {
        return this.matrix.toString();
    }

    public JavaVersion getMinimumVersion() {
        JavaRuntime runtime = null;
        try {
            runtime = JavaRuntime.current();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getMinimumVersion(runtime);
    }

    public JavaVersion getMinimumVersion(JavaRuntime runtime) {
        return this.getVersion(runtime, MINIMUM_SUFFIX);
    }

    public JavaVersion getPreferredVersion() {
        JavaRuntime runtime = null;
        try {
            runtime = JavaRuntime.current();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getPreferredVersion(runtime);
    }

    public JavaVersion getPreferredVersion(JavaRuntime runtime) {
        return this.getVersion(runtime, PREFERRED_SUFFIX);
    }

    public PlatformSupport getSupport(List<Message> messages) {
        return this.getSupport(System.getProperties(), messages);
    }

    public PlatformSupport getSupport(Properties systemProperties, List<Message> messages) {
        JavaRuntime runtime;
        JavaVersion version;
        String vendorString = systemProperties.getProperty("java.vendor");
        String runtimeString = systemProperties.getProperty("java.runtime.name");
        String suppressUnrecognizedWarningString = System.getenv(SUPPRESS_UNRECOGNIZED_WARNINGS);
        Boolean suppressUnrecognizedWarning = suppressUnrecognizedWarningString != null && !suppressUnrecognizedWarningString.isEmpty() ? Boolean.valueOf(Boolean.parseBoolean(suppressUnrecognizedWarningString)) : Boolean.valueOf(Boolean.parseBoolean(systemProperties.getProperty(SUPPRESS_UNRECOGNIZED_WARNINGS_PROPERTY)));
        if (vendorString == null || runtimeString == null) {
            throw new IllegalStateException(String.format("Property java.vendor (%s) or java.runtime.name (%s) missing from System properties.", vendorString, runtimeString));
        }
        String versionString = systemProperties.getProperty("java.version");
        if (versionString == null) {
            throw new IllegalStateException(String.format("Property java.version missing from System properties.", new Object[0]));
        }
        try {
            version = JavaVersion.valueOfString(versionString);
        }
        catch (IllegalArgumentException iae) {
            messages.add(Message.fromObject((Object)iae, (Object[])new Object[0]));
            messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_UNKNOWN.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
            return PlatformSupport.UNRECOGNIZED;
        }
        try {
            runtime = JavaRuntime.valueOfString(runtimeString);
        }
        catch (IllegalArgumentException iae) {
            JavaVersion defaultMinimum = this.getMinimumVersion(null);
            if (version != null && version.ordinal() < defaultMinimum.ordinal()) {
                messages.add(UBIDCommonMessages.ERR_PLATFORM_SUPPORT_MINIMUM.get((Object)defaultMinimum.getName()));
                return PlatformSupport.RETIRED;
            }
            if (!suppressUnrecognizedWarning.booleanValue()) {
                messages.add(Message.fromObject((Object)iae, (Object[])new Object[0]));
                messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_UNKNOWN.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
            }
            return PlatformSupport.UNRECOGNIZED;
        }
        String key = "";
        if (vendorString.startsWith("IBM")) {
            JavaVendor vendor = JavaVendor.valueOfString(vendorString);
            key = JavaSupportMatrix.createJavaSupportKey(vendor, runtime, version);
        } else {
            key = JavaSupportMatrix.createJavaSupportKey(runtime, version);
        }
        String value = this.matrix.get(key);
        if (value == null) {
            if (!suppressUnrecognizedWarning.booleanValue()) {
                messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_UNKNOWN.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
            }
            return PlatformSupport.UNRECOGNIZED;
        }
        PlatformSupport platformSupport = PlatformSupport.valueOf(value.toUpperCase());
        String minimum = this.getMinimumVersion(runtime).getName();
        String preferred = this.getPreferredVersion(runtime).getName();
        switch (platformSupport) {
            case DEPRECATED: {
                if (preferred.equals(minimum)) {
                    messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_DEPRECATED.get((Object)versionString, (Object)vendorString, (Object)runtimeString));
                    break;
                }
                messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_DEPRECATED_2.get((Object)versionString, (Object)vendorString, (Object)runtimeString, (Object)preferred));
                break;
            }
            case RETIRED: {
                if (preferred.equals(minimum)) {
                    messages.add(UBIDCommonMessages.ERR_PLATFORM_SUPPORT_RETIRED.get((Object)versionString, (Object)vendorString, (Object)runtimeString, (Object)minimum));
                    break;
                }
                messages.add(UBIDCommonMessages.ERR_PLATFORM_SUPPORT_RETIRED_2.get((Object)versionString, (Object)vendorString, (Object)runtimeString, (Object)minimum, (Object)preferred));
                break;
            }
            case EVALUATION_ONLY: {
                messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_EVALUATION_ONLY.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
                break;
            }
            case EXPERIMENTAL: {
                messages.add(UBIDCommonMessages.WARN_PLATFORM_SUPPORT_EXPERIMENTAL.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
                break;
            }
            case UNSUPPORTED: {
                messages.add(UBIDCommonMessages.ERR_PLATFORM_SUPPORT_UNSUPPORTED.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
                break;
            }
            case INCOMPATIBLE: {
                messages.add(UBIDCommonMessages.ERR_PLATFORM_SUPPORT_INCOMPATIBLE.get((Object)vendorString, (Object)runtimeString, (Object)versionString));
            }
        }
        return platformSupport;
    }

    private void setMatrix(Properties properties) {
        this.matrix = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            if (key.startsWith("IBM") || key.startsWith("default") || key.endsWith(MINIMUM_SUFFIX) || key.endsWith(PREFERRED_SUFFIX)) {
                this.matrix.put(key, properties.getProperty(key));
                continue;
            }
            this.matrix.put(key.substring(key.indexOf(45) + 1), properties.getProperty(key));
        }
        String defaultMinimumKey = "default-minimum";
        if (this.matrix.get(defaultMinimumKey) == null) {
            throw new IllegalArgumentException("Matrix does not define a default minimum Java version");
        }
        String defaultPreferredKey = "default-preferred";
        if (this.matrix.get(defaultPreferredKey) == null) {
            throw new IllegalArgumentException("Matrix does not define a default preferred Java version");
        }
    }

    private JavaVersion getVersion(JavaRuntime runtime, String propertySuffix) {
        String versionKeyPrefix;
        String s;
        if (runtime != null && (s = this.matrix.get((versionKeyPrefix = JavaSupportMatrix.createJavaSupportKeyPrefix(runtime)) + propertySuffix)) != null) {
            return JavaVersion.valueOfString(s);
        }
        return JavaVersion.valueOfString(this.matrix.get("default-" + propertySuffix));
    }

    public static String createJavaSupportKey(JavaVendor vendor, JavaRuntime runtime, JavaVersion version) {
        return JavaSupportMatrix.createJavaSupportKeyPrefix(vendor, runtime) + version.getName();
    }

    public static String createJavaSupportKey(JavaRuntime runtime, JavaVersion version) {
        return JavaSupportMatrix.createJavaSupportKeyPrefix(runtime) + version.getName();
    }

    public static String createJavaSupportKeyPrefix(JavaVendor vendor, JavaRuntime runtime) {
        return vendor.getName() + "-" + runtime.getName() + "-";
    }

    public static String createJavaSupportKeyPrefix(JavaRuntime runtime) {
        return runtime.getName() + "-";
    }
}

