/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.platform;

import java.util.EnumSet;

public enum JavaVendor {
    SUN("Sun Microsystems Inc."),
    ORACLE("Oracle Corporation"),
    IBM("IBM Corporation"),
    AZUL("Azul Systems, Inc."),
    AMAZON("Amazon.com Inc."),
    ADOPTOPENJDK("AdoptOpenJDK"),
    BELLSOFT("BellSoft"),
    ECLIPSEFOUNDATION("Eclipse Foundation"),
    ECLIPSEADOPTIUM("Eclipse Adoptium"),
    REDHAT("Red Hat, Inc."),
    UBUNTU("Ubuntu"),
    PRIVATE_BUILD("Private Build");

    private final String name;

    public static JavaVendor current() {
        return JavaVendor.valueOfString(System.getProperty("java.vendor"));
    }

    public static JavaVendor valueOfString(String name) {
        for (JavaVendor vendor : EnumSet.allOf(JavaVendor.class)) {
            if (!vendor.name.toLowerCase().startsWith(name.toLowerCase())) continue;
            return vendor;
        }
        throw new IllegalArgumentException("Unknown vendor " + name);
    }

    public String getName() {
        return this.name;
    }

    private JavaVendor(String name) {
        this.name = name;
    }
}

