/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BuildVersion
implements Comparable<BuildVersion> {
    public static final Pattern VERSION_STRING_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)(.*?)(-build(\\d+))?$");
    int major;
    int minor;
    int point;
    int patch;
    String qualifier;
    int buildNumber;

    public static BuildVersion fromVersionString(String s) throws IllegalArgumentException {
        Matcher m = VERSION_STRING_PATTERN.matcher(s);
        if (m.matches()) {
            int major = Integer.parseInt(m.group(1));
            int minor = Integer.parseInt(m.group(2));
            int point = Integer.parseInt(m.group(3));
            int patch = Integer.parseInt(m.group(4));
            String qualifier = m.group(5);
            Integer buildNumber = m.group(7) != null ? Integer.valueOf(Integer.parseInt(m.group(7))) : null;
            return new BuildVersion(major, minor, point, patch, qualifier, buildNumber);
        }
        throw new IllegalArgumentException("Invalid build string " + s);
    }

    public BuildVersion(int major, int minor, int point, int patch, String qualifier, Integer build) {
        this.major = major;
        this.minor = minor;
        this.point = point;
        this.patch = patch;
        this.qualifier = qualifier != null ? qualifier : "";
        this.buildNumber = build != null && build > 0 ? build : -1;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPointVersion() {
        return this.point;
    }

    public int getPatchVersion() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Integer getBuildNumber() {
        return this.buildNumber > 0 ? Integer.valueOf(this.buildNumber) : null;
    }

    @Override
    public int compareTo(BuildVersion version) {
        if (this.major == version.major) {
            if (this.minor == version.minor) {
                if (this.point == version.point) {
                    if (this.patch == version.patch) {
                        if (this.buildNumber == version.buildNumber) {
                            return 0;
                        }
                        if (this.buildNumber < version.buildNumber) {
                            return -1;
                        }
                    } else if (this.patch < version.patch) {
                        return -1;
                    }
                } else if (this.point < version.point) {
                    return -1;
                }
            } else if (this.minor < version.minor) {
                return -1;
            }
        } else if (this.major < version.major) {
            return -1;
        }
        return 1;
    }

    public boolean comesBefore(String version) {
        return this.compareTo(BuildVersion.fromVersionString(version)) < 0;
    }

    public boolean comesBefore(BuildVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean comesAfter(BuildVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean comesAfter(String version) {
        return this.compareTo(BuildVersion.fromVersionString(version)) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildVersion)) {
            return false;
        }
        BuildVersion that = (BuildVersion)o;
        if (this.buildNumber != that.buildNumber) {
            return false;
        }
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.patch != that.patch) {
            return false;
        }
        if (this.point != that.point) {
            return false;
        }
        return this.qualifier.equals(that.qualifier);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.point;
        result = 31 * result + this.patch;
        result = 31 * result + this.qualifier.hashCode();
        result = 31 * result + this.buildNumber;
        return result;
    }

    public String toVersionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(".").append(this.minor).append(".").append(this.point).append(".").append(this.patch);
        if (this.qualifier != null && !this.qualifier.isEmpty()) {
            sb.append(this.qualifier);
        }
        if (this.buildNumber > 0) {
            sb.append("-build");
            sb.append(new DecimalFormat("000").format(this.buildNumber));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toVersionString();
    }
}

