/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import com.unboundid.common.debug.CommonDebugTracer;
import com.unboundid.common.debug.DebugLogLevel;
import com.unboundid.common.debug.DebugLogger;
import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.types.FileException;
import com.unboundid.common.types.OperatingSystem;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.messages.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.Set;

public class FilePermission {
    private static final OperatingSystem operatingSystem;
    private static final CommonDebugTracer TRACER;
    public static final int OWNER_READABLE = 256;
    public static final int OWNER_WRITABLE = 128;
    public static final int OWNER_EXECUTABLE = 64;
    public static final int GROUP_READABLE = 32;
    public static final int GROUP_WRITABLE = 16;
    public static final int GROUP_EXECUTABLE = 8;
    public static final int OTHER_READABLE = 4;
    public static final int OTHER_WRITABLE = 2;
    public static final int OTHER_EXECUTABLE = 1;
    private static boolean allowExec;
    private static Method setExecutableMethod;
    private static Method setReadableMethod;
    private static Method setWritableMethod;
    private static Method pathsGet;
    private static Method posixFilePermsFromString;
    private static Method filesSetPosixFilePermissions;
    private static boolean java7NioMethodsAvailable;
    private int encodedPermission;

    public FilePermission(int encodedPermission) {
        this.encodedPermission = encodedPermission;
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
        if (groupReadable) {
            this.encodedPermission |= 0x20;
        }
        if (groupWritable) {
            this.encodedPermission |= 0x10;
        }
        if (groupExecutable) {
            this.encodedPermission |= 8;
        }
        if (otherReadable) {
            this.encodedPermission |= 4;
        }
        if (otherWritable) {
            this.encodedPermission |= 2;
        }
        if (otherExecutable) {
            this.encodedPermission |= 1;
        }
    }

    public boolean isOwnerReadable() {
        return (this.encodedPermission & 0x100) == 256;
    }

    public boolean isOwnerWritable() {
        return (this.encodedPermission & 0x80) == 128;
    }

    public boolean isOwnerExecutable() {
        return (this.encodedPermission & 0x40) == 64;
    }

    public boolean isGroupReadable() {
        return (this.encodedPermission & 0x20) == 32;
    }

    public boolean isGroupWritable() {
        return (this.encodedPermission & 0x10) == 16;
    }

    public boolean isGroupExecutable() {
        return (this.encodedPermission & 8) == 8;
    }

    public boolean isOtherReadable() {
        return (this.encodedPermission & 4) == 4;
    }

    public boolean isOtherWritable() {
        return (this.encodedPermission & 2) == 2;
    }

    public boolean isOtherExecutable() {
        return (this.encodedPermission & 1) == 1;
    }

    public static boolean canSetPermissions() {
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return true;
        }
        OperatingSystem os = FilePermission.getOperatingSystem();
        return allowExec && os != null && OperatingSystem.isUNIXBased(os);
    }

    public static boolean setPermissions(File f, FilePermission p) throws FileNotFoundException, FileException {
        block6: {
            if (!f.exists()) {
                Message message = UBIDCommonMessages.ERR_FILEPERM_SET_NO_SUCH_FILE.get((Object)f.getAbsolutePath());
                throw new FileNotFoundException(message.toString());
            }
            if (java7NioMethodsAvailable) {
                try {
                    FilePermission.setJava7FilePermissions(f.getAbsolutePath(), FilePermission.toUNIXMode(p));
                    return true;
                }
                catch (Exception e) {
                    OperatingSystem os = FilePermission.getOperatingSystem();
                    if (!DebugLogger.debugEnabled() || os != null && OperatingSystem.isWindows(os)) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        if (setReadableMethod != null && setWritableMethod != null && setExecutableMethod != null) {
            return FilePermission.setUsingJava(f, p);
        }
        OperatingSystem os = FilePermission.getOperatingSystem();
        if (allowExec && os != null && OperatingSystem.isUNIXBased(os)) {
            return FilePermission.setUsingUNIX(f, p);
        }
        return false;
    }

    private static boolean setUsingUNIX(File f, FilePermission p) throws FileException {
        int exitCode;
        String[] arguments = new String[]{FilePermission.toUNIXMode(p), f.getAbsolutePath()};
        try {
            exitCode = SystemUtils.exec("chmod", arguments, null, null, null);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UBIDCommonMessages.ERR_FILEPERM_CANNOT_EXEC_CHMOD.get((Object)f.getAbsolutePath(), (Object)String.valueOf(e));
            throw new FileException(message, (Throwable)e);
        }
        return exitCode == 0;
    }

    private static boolean setUsingJava(File f, FilePermission p) throws FileException {
        Boolean b;
        boolean anySuccessful = false;
        boolean anyFailed = false;
        boolean exceptionThrown = false;
        if (p.isOwnerReadable() && !p.isOtherReadable()) {
            try {
                Boolean b2 = (Boolean)setReadableMethod.invoke((Object)f, false, false);
                if (b2.booleanValue()) {
                    anySuccessful = true;
                } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerReadable() != p.isOtherReadable();
            b = (Boolean)setReadableMethod.invoke((Object)f, p.isOwnerReadable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) && !p.isOwnerReadable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (p.isOwnerWritable() && !p.isOtherWritable()) {
            try {
                Boolean b3 = (Boolean)setWritableMethod.invoke((Object)f, false, false);
                if (b3.booleanValue()) {
                    anySuccessful = true;
                } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerWritable() != p.isOtherWritable();
            b = (Boolean)setWritableMethod.invoke((Object)f, p.isOwnerWritable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) && !p.isOwnerWritable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (p.isOwnerExecutable() && !p.isOtherExecutable()) {
            try {
                Boolean b4 = (Boolean)setExecutableMethod.invoke((Object)f, false, false);
                if (b4.booleanValue()) {
                    anySuccessful = true;
                } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly = p.isOwnerExecutable() != p.isOtherExecutable();
            b = (Boolean)setExecutableMethod.invoke((Object)f, p.isOwnerExecutable(), ownerOnly);
            if (b.booleanValue()) {
                anySuccessful = true;
            } else if (!FilePermission.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) && !p.isOwnerExecutable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            Message message = UBIDCommonMessages.ERR_FILEPERM_SET_JAVA_EXCEPTION.get((Object)f.getAbsolutePath());
            throw new FileException(message);
        }
        if (anyFailed) {
            if (anySuccessful) {
                Message message = UBIDCommonMessages.ERR_FILEPERM_SET_JAVA_FAILED_ALTERED.get((Object)f.getAbsolutePath());
                throw new FileException(message);
            }
            Message message = UBIDCommonMessages.ERR_FILEPERM_SET_JAVA_FAILED_UNALTERED.get((Object)f.getAbsolutePath());
            throw new FileException(message);
        }
        return anySuccessful;
    }

    public static String toUNIXMode(FilePermission p) {
        StringBuilder buffer = new StringBuilder(3);
        FilePermission.toUNIXMode(buffer, p);
        return buffer.toString();
    }

    public static void toUNIXMode(StringBuilder buffer, FilePermission p) {
        int modeByte = 0;
        if (p.isOwnerReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOwnerWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOwnerExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isGroupReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isGroupWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isGroupExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isOtherReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOtherWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOtherExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
    }

    public static FilePermission decodeUNIXMode(String modeString) throws FileException {
        if (modeString == null || modeString.length() != 3) {
            Message message = UBIDCommonMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get((Object)String.valueOf(modeString));
            throw new FileException(message);
        }
        int encodedPermission = 0;
        switch (modeString.charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 0x40;
                break;
            }
            case '2': {
                encodedPermission |= 0x80;
                break;
            }
            case '3': {
                encodedPermission |= 0xC0;
                break;
            }
            case '4': {
                encodedPermission |= 0x100;
                break;
            }
            case '5': {
                encodedPermission |= 0x140;
                break;
            }
            case '6': {
                encodedPermission |= 0x180;
                break;
            }
            case '7': {
                encodedPermission |= 0x1C0;
                break;
            }
            default: {
                Message message = UBIDCommonMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get((Object)String.valueOf(modeString));
                throw new FileException(message);
            }
        }
        switch (modeString.charAt(1)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 8;
                break;
            }
            case '2': {
                encodedPermission |= 0x10;
                break;
            }
            case '3': {
                encodedPermission |= 0x18;
                break;
            }
            case '4': {
                encodedPermission |= 0x20;
                break;
            }
            case '5': {
                encodedPermission |= 0x28;
                break;
            }
            case '6': {
                encodedPermission |= 0x30;
                break;
            }
            case '7': {
                encodedPermission |= 0x38;
                break;
            }
            default: {
                Message message = UBIDCommonMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get((Object)String.valueOf(modeString));
                throw new FileException(message);
            }
        }
        switch (modeString.charAt(2)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 1;
                break;
            }
            case '2': {
                encodedPermission |= 2;
                break;
            }
            case '3': {
                encodedPermission |= 3;
                break;
            }
            case '4': {
                encodedPermission |= 4;
                break;
            }
            case '5': {
                encodedPermission |= 5;
                break;
            }
            case '6': {
                encodedPermission |= 6;
                break;
            }
            case '7': {
                encodedPermission |= 7;
                break;
            }
            default: {
                Message message = UBIDCommonMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get((Object)String.valueOf(modeString));
                throw new FileException(message);
            }
        }
        return new FilePermission(encodedPermission);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("Owner=");
        if (this.isOwnerReadable()) {
            buffer.append("r");
        }
        if (this.isOwnerWritable()) {
            buffer.append("w");
        }
        if (this.isOwnerExecutable()) {
            buffer.append("x");
        }
        buffer.append(", Group=");
        if (this.isGroupReadable()) {
            buffer.append("r");
        }
        if (this.isGroupWritable()) {
            buffer.append("w");
        }
        if (this.isGroupExecutable()) {
            buffer.append("x");
        }
        buffer.append(", Other=");
        if (this.isOtherReadable()) {
            buffer.append("r");
        }
        if (this.isOtherWritable()) {
            buffer.append("w");
        }
        if (this.isOtherExecutable()) {
            buffer.append("x");
        }
    }

    private static OperatingSystem getOperatingSystem() {
        return operatingSystem;
    }

    public static String getUnixPermissionsAsString(String unixMode) {
        int mode = Integer.valueOf(unixMode);
        if (mode < 0) {
            throw new IllegalArgumentException(String.format("%d is not a valid unix permission mode", mode));
        }
        int user = mode / 100;
        int group = (mode - user * 100) / 10;
        int other = mode - user * 100 - group * 10;
        if (user > 7 || group > 7 || other > 7) {
            throw new IllegalArgumentException(String.format("%d is not a valid unix permission mode", mode));
        }
        String[] permsMap = new String[]{"---", "--x", "-w-", "-wx", "r--", "r-x", "rw-", "rwx"};
        return String.format("%s%s%s", permsMap[user], permsMap[group], permsMap[other]);
    }

    protected static void setJava7FilePermissions(String fullPath, String unixMode) throws Exception {
        Object path = pathsGet.invoke(null, fullPath, new String[0]);
        Set setOfPerms = (Set)posixFilePermsFromString.invoke(null, FilePermission.getUnixPermissionsAsString(unixMode));
        filesSetPosixFilePermissions.invoke(null, path, setOfPerms);
    }

    public static boolean getJava7NioMethodsAvailable() {
        return java7NioMethodsAvailable;
    }

    static {
        block8: {
            operatingSystem = OperatingSystem.local();
            TRACER = DebugLogger.getTracer();
            java7NioMethodsAvailable = false;
            try {
                Method[] permsClass = Class.forName("java.nio.file.attribute.PosixFilePermissions");
                Class<?> pathsClass = Class.forName("java.nio.file.Paths");
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                pathsGet = pathsClass.getMethod("get", String.class, String[].class);
                posixFilePermsFromString = permsClass.getMethod("fromString", String.class);
                filesSetPosixFilePermissions = filesClass.getMethod("setPosixFilePermissions", pathClass, Set.class);
                java7NioMethodsAvailable = true;
            }
            catch (ClassNotFoundException permsClass) {
            }
            catch (NoSuchMethodException permsClass) {
                // empty catch block
            }
            try {
                setExecutableMethod = null;
                setReadableMethod = null;
                setWritableMethod = null;
                for (Method m : File.class.getMethods()) {
                    String name = m.getName();
                    Class<?>[] argTypes = m.getParameterTypes();
                    if (name.equals("setExecutable") && argTypes.length == 2) {
                        setExecutableMethod = m;
                        continue;
                    }
                    if (name.equals("setReadable") && argTypes.length == 2) {
                        setReadableMethod = m;
                        continue;
                    }
                    if (!name.equals("setWritable") || argTypes.length != 2) continue;
                    setWritableMethod = m;
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        allowExec = SystemUtils.mayUseExec();
    }
}

