/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.types;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum SizeUnit {
    BYTES(1L, "b", "bytes"),
    KILOBYTES(1024L, "kb", "kilobytes"),
    MEGABYTES(0x100000L, "mb", "megabytes"),
    GIGABYTES(0x40000000L, "gb", "gigabytes"),
    TERABYTES(0x10000000000L, "tb", "terabytes");

    private static final Map<String, SizeUnit> nameToUnit;
    private final String longName;
    private final String shortName;
    private final long sz;

    public static SizeUnit getBestFitUnit(long bytes) throws IllegalArgumentException {
        SizeUnit[] units;
        if (bytes < 0L) {
            throw new IllegalArgumentException("negative number of bytes: " + bytes);
        }
        if (bytes == 0L) {
            return BYTES;
        }
        for (SizeUnit unit : units = new SizeUnit[]{TERABYTES, GIGABYTES, MEGABYTES, KILOBYTES}) {
            if (bytes / unit.getSize() <= 0L) continue;
            return unit;
        }
        return BYTES;
    }

    public static SizeUnit getBestFitUnitExact(long bytes) throws IllegalArgumentException {
        SizeUnit[] units;
        if (bytes < 0L) {
            throw new IllegalArgumentException("negative number of bytes: " + bytes);
        }
        if (bytes == 0L) {
            return BYTES;
        }
        for (SizeUnit unit : units = new SizeUnit[]{TERABYTES, GIGABYTES, MEGABYTES, KILOBYTES}) {
            if (bytes % unit.getSize() != 0L) continue;
            return unit;
        }
        return BYTES;
    }

    public static SizeUnit getUnit(String s) throws IllegalArgumentException {
        SizeUnit unit = nameToUnit.get(s.trim().toLowerCase());
        if (unit == null) {
            throw new IllegalArgumentException("Illegal memory size unit \"" + s + "\"");
        }
        return unit;
    }

    public static long parseValue(String s) throws NumberFormatException {
        return SizeUnit.parseValue(s, null);
    }

    public static long parseValue(String s, SizeUnit defaultUnit) throws NumberFormatException {
        SizeUnit unit;
        double d;
        Pattern p = Pattern.compile("^\\s*(\\d+(\\.\\d+)?)\\s*(\\w+)?\\s*$");
        Matcher m = p.matcher(s);
        if (!m.matches()) {
            throw new NumberFormatException("Invalid size value \"" + s + "\"");
        }
        try {
            d = Double.valueOf(m.group(1));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid size value \"" + s + "\"");
        }
        String unitString = m.group(3);
        if (unitString == null) {
            if (defaultUnit == null) {
                throw new NumberFormatException("Invalid size value \"" + s + "\"");
            }
            unit = defaultUnit;
        } else {
            try {
                unit = SizeUnit.getUnit(unitString);
            }
            catch (IllegalArgumentException e) {
                throw new NumberFormatException("Invalid size value \"" + s + "\"");
            }
        }
        return unit.toBytes(d);
    }

    private SizeUnit(long sz, String shortName, String longName) {
        this.sz = sz;
        this.shortName = shortName;
        this.longName = longName;
    }

    public double fromBytes(long amount) {
        return (double)amount / (double)this.sz;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public long getSize() {
        return this.sz;
    }

    public long toBytes(double amount) throws NumberFormatException {
        double value = (double)this.sz * amount;
        if (value > 9.223372036854776E18) {
            throw new NumberFormatException("number too big (exceeded long.MAX_VALUE");
        }
        return (long)value;
    }

    public String toString() {
        return this.shortName;
    }

    static {
        nameToUnit = new HashMap<String, SizeUnit>();
        for (SizeUnit unit : SizeUnit.values()) {
            nameToUnit.put(unit.shortName, unit);
            nameToUnit.put(unit.longName, unit);
        }
    }
}

