/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.update;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.types.FileException;
import com.unboundid.common.types.FilePermission;
import com.unboundid.common.util.FileDigest;
import com.unboundid.common.util.FileUtils;
import com.unboundid.messages.Message;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileManager {
    public static final String WINDOWS_BINARIES_PATH_RELATIVE = "bat";
    public static final String UNIX_BINARIES_PATH_RELATIVE = "bin";
    public static final String UNIX_SETUP_FILE_NAME = "setup";
    public static final String UNIX_UNINSTALL_FILE_NAME = "uninstall";
    public static final String UNIX_UPGRADE_FILE_NAME = "update";
    public static final String MAC_JAVA_APP_STUB_NAME = "JavaApplicationStub";
    private static final Logger LOG = Logger.getLogger(FileManager.class.getName());
    private FileDigest fileDigest;

    public void setFileDigest(FileDigest digest) {
        this.fileDigest = digest;
    }

    public void synchronize(File source, File target) throws FileException {
        String[] sourceFileNames;
        if (source != null && target != null && (sourceFileNames = source.list()) != null) {
            for (String sourceFileName : sourceFileNames) {
                File sourceFile = new File(source, sourceFileName);
                this.copyRecursively(sourceFile, target, null, false);
            }
        }
    }

    public void synchronize(File source, File target, FileFilter filter) throws FileException {
        this.synchronize(source, target, filter, false);
    }

    public void synchronize(File source, File target, FileFilter filter, boolean overwrite) throws FileException {
        String[] sourceFileNames;
        if (source != null && target != null && (sourceFileNames = source.list()) != null) {
            for (String sourceFileName : sourceFileNames) {
                File sourceFile = new File(source, sourceFileName);
                this.copyRecursively(sourceFile, target, filter, overwrite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(File fileToRename, File target) throws FileException {
        if (fileToRename != null && target != null) {
            File file = target;
            synchronized (file) {
                if (target.exists() && !target.delete()) {
                    throw new FileException(UBIDCommonMessages.ERR_DELETING_FILE.get((Object)FileUtils.getPath(target)), null);
                }
            }
            if (!fileToRename.renameTo(target)) {
                throw new FileException(UBIDCommonMessages.ERR_RENAMING_FILE.get((Object)FileUtils.getPath(fileToRename), (Object)FileUtils.getPath(target)), null);
            }
        }
    }

    public void move(File object, File newParent) throws FileException {
        this.move(object, newParent, null, false);
    }

    public void move(File object, File newParent, FileFilter filter, boolean filterChildren) throws FileException {
        if (filterChildren) {
            MoveOperationRecursive fileOp = new MoveOperationRecursive(object, newParent, filter);
            this.operateRecursively(fileOp, filter);
        } else if (filter == null || filter.accept(object)) {
            if (!newParent.exists() && !newParent.mkdirs()) {
                throw new FileException(UBIDCommonMessages.ERR_ERROR_FAILED_MOVING_FILE.get((Object)FileUtils.getPath(object), (Object)FileUtils.getPath(newParent), (Object)UBIDCommonMessages.ERR_INFO_FM_PARENT_CREATION_ERROR.get((Object)FileUtils.getPath(newParent))), null);
            }
            new MoveOperation(object, newParent).apply();
        }
    }

    public void delete(File object) throws FileException {
        this.delete(object, null);
    }

    public void delete(File object, FileFilter filter) throws FileException {
        if (filter == null || filter.accept(object)) {
            new DeleteOperation(object, DeletionPolicy.DELETE_IMMEDIATELY).apply();
        }
    }

    public void deleteChildren(File parentDir) throws FileException {
        File[] children;
        if (parentDir != null && parentDir.exists() && parentDir.isDirectory() && (children = parentDir.listFiles()) != null) {
            for (File child : children) {
                this.delete(child);
            }
        }
    }

    public void deleteRecursively(File file) throws FileException {
        this.deleteRecursively(file, null, DeletionPolicy.DELETE_IMMEDIATELY);
    }

    public void deleteRecursively(File file, FileFilter filter, DeletionPolicy deletePolicy) throws FileException {
        this.operateRecursively(new DeleteOperation(file, deletePolicy), filter);
    }

    public File copy(File objectFile, File destDir) throws FileException {
        CopyOperation co = new CopyOperation(objectFile, destDir, false);
        co.apply();
        return co.getDestination();
    }

    public File copy(File objectFile, File destDir, boolean overwrite) throws FileException {
        CopyOperation co = new CopyOperation(objectFile, destDir, overwrite);
        co.apply();
        return co.getDestination();
    }

    public void copyRecursively(File objectFile, File destDir) throws FileException {
        this.copyRecursively(objectFile, destDir, null);
    }

    public void copyRecursively(File objectFile, File destDir, FileFilter filter) throws FileException {
        this.copyRecursively(objectFile, destDir, filter, false);
    }

    public void copyRecursively(File objectFile, File destDir, FileFilter filter, boolean overwrite) throws FileException {
        this.operateRecursively(new CopyOperation(objectFile, destDir, overwrite), filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filesDiffer(File f1, File f2) throws IOException {
        boolean differ = false;
        FileReader fr1 = null;
        FileReader fr2 = null;
        try {
            fr1 = new FileReader(f1);
            fr2 = new FileReader(f2);
            boolean done = false;
            while (!differ && !done) {
                int c2;
                int c1 = fr1.read();
                differ = c1 != (c2 = fr2.read());
                done = c1 == -1 || c2 == -1;
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(fr1);
            FileUtils.close(fr2);
            throw throwable;
        }
        FileUtils.close(fr1);
        FileUtils.close(fr2);
        return differ;
    }

    private void operateRecursively(FileOperation op, FileFilter filter) throws FileException {
        File file = op.getObjectFile();
        if (file.exists()) {
            if (file.isFile()) {
                if (filter != null) {
                    if (filter.accept(file)) {
                        op.apply();
                    }
                } else {
                    op.apply();
                }
            } else if (filter == null || filter.accept(file)) {
                File[] children = file.listFiles();
                if (children != null) {
                    for (File aChildren : children) {
                        FileOperation newOp = op.copyForChild(aChildren);
                        this.operateRecursively(newOp, filter);
                    }
                }
                op.apply();
            }
        } else {
            LOG.log(Level.INFO, "file '" + file.toString() + "' does not exist");
        }
    }

    private static boolean ensureParentsExist(File f) {
        File parent = f.getParentFile();
        boolean b = parent.exists();
        if (!b) {
            b = parent.mkdirs();
        }
        return b;
    }

    private static String getFileSystemPermissions(File file) {
        String name = file.getName();
        String perm = file.getParent().endsWith(File.separator + WINDOWS_BINARIES_PATH_RELATIVE) || file.getParent().endsWith(File.separator + UNIX_BINARIES_PATH_RELATIVE) ? (name.endsWith(".bat") ? "644" : "755") : (name.endsWith(".sh") ? "755" : (name.endsWith(UNIX_SETUP_FILE_NAME) || name.endsWith(UNIX_UNINSTALL_FILE_NAME) || name.endsWith(UNIX_UPGRADE_FILE_NAME) ? "755" : (name.endsWith(MAC_JAVA_APP_STUB_NAME) ? "755" : "644")));
        return perm;
    }

    private class MoveOperationRecursive
    extends FileOperation {
        File destination;
        FileFilter filter;

        public MoveOperationRecursive(File objectFile, File newParent, FileFilter filter) {
            super(objectFile);
            this.destination = null;
            this.filter = null;
            this.destination = new File(newParent, objectFile.getName());
            this.filter = filter;
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new MoveOperationRecursive(child, this.destination, this.filter);
        }

        @Override
        public void apply() throws FileException {
            File objectFile = this.getObjectFile();
            if (objectFile.isDirectory()) {
                String[] children = objectFile.list();
                if (children != null && children.length == 0 && !objectFile.delete()) {
                    throw FileException.createFileSystemException(UBIDCommonMessages.ERR_FAILED_MOVING_FILE.get((Object)FileUtils.getPath(objectFile), (Object)FileUtils.getPath(this.destination)), null);
                }
                if (!this.destination.exists() && !this.destination.mkdir()) {
                    throw FileException.createFileSystemException(UBIDCommonMessages.ERR_FAILED_MOVING_FILE.get((Object)FileUtils.getPath(objectFile), (Object)FileUtils.getPath(this.destination)), null);
                }
            } else {
                FileManager.ensureParentsExist(this.destination);
                if (!objectFile.renameTo(this.destination)) {
                    throw FileException.createFileSystemException(UBIDCommonMessages.ERR_FAILED_MOVING_FILE.get((Object)FileUtils.getPath(objectFile), (Object)FileUtils.getPath(this.destination)), null);
                }
            }
        }
    }

    private class MoveOperation
    extends FileOperation {
        File destination;

        public MoveOperation(File objectFile, File newParent) {
            super(objectFile);
            this.destination = null;
            this.destination = new File(newParent, objectFile.getName());
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new MoveOperation(child, this.destination);
        }

        @Override
        public void apply() throws FileException {
            File objectFile = this.getObjectFile();
            if (this.destination.exists()) {
                FileManager.this.deleteRecursively(this.destination);
            }
            if (!objectFile.renameTo(this.destination)) {
                throw FileException.createFileSystemException(UBIDCommonMessages.ERR_FAILED_MOVING_FILE.get((Object)FileUtils.getPath(objectFile), (Object)FileUtils.getPath(this.destination)), null);
            }
        }
    }

    private class DeleteOperation
    extends FileOperation {
        private DeletionPolicy deletionPolicy;

        public DeleteOperation(File objectFile, DeletionPolicy deletionPolicy) {
            super(objectFile);
            this.deletionPolicy = deletionPolicy;
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new DeleteOperation(child, this.deletionPolicy);
        }

        @Override
        public void apply() throws FileException {
            File file = this.getObjectFile();
            boolean isFile = file.isFile();
            LOG.log(Level.INFO, "deleting " + (isFile ? " file " : " directory ") + file.getAbsolutePath());
            boolean delete = false;
            int nTries = 5;
            for (int i = 0; i < nTries && !delete; ++i) {
                if (DeletionPolicy.DELETE_ON_EXIT.equals((Object)this.deletionPolicy)) {
                    file.deleteOnExit();
                    delete = true;
                } else {
                    delete = file.delete();
                    if (!delete && DeletionPolicy.DELETE_ON_EXIT_IF_UNSUCCESSFUL.equals((Object)this.deletionPolicy)) {
                        file.deleteOnExit();
                        delete = true;
                    }
                }
                if (delete) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!delete) {
                Message errMsg = isFile ? UBIDCommonMessages.ERR_DELETING_FILE.get((Object)file.getAbsolutePath()) : UBIDCommonMessages.ERR_DELETING_DIRECTORY.get((Object)file.getAbsolutePath());
                throw new FileException(errMsg, null);
            }
        }
    }

    private class CopyOperation
    extends FileOperation {
        private File destination;
        private boolean overwrite;

        public CopyOperation(File objectFile, File destDir, boolean overwrite) {
            super(objectFile);
            this.destination = new File(destDir, objectFile.getName());
            this.overwrite = overwrite;
        }

        @Override
        public FileOperation copyForChild(File child) {
            return new CopyOperation(child, this.destination, this.overwrite);
        }

        public File getDestination() {
            return this.destination;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void apply() throws FileException {
            File objectFile = this.getObjectFile();
            if (objectFile.isDirectory()) {
                if (this.destination.exists()) return;
                this.destination.mkdirs();
                return;
            }
            if (this.destination.exists() && this.overwrite) {
                FileManager.this.deleteRecursively(this.destination);
            }
            if (!this.destination.exists()) {
                if (FileManager.ensureParentsExist(this.destination)) {
                    LOG.log(Level.INFO, "copying file '" + objectFile.getAbsolutePath() + "' to '" + this.destination.getAbsolutePath() + "'");
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    try {
                        int i;
                        fis = new FileInputStream(objectFile);
                        fos = new FileOutputStream(this.destination);
                        byte[] buf = new byte[1024];
                        while ((i = fis.read(buf)) != -1) {
                            fos.write(buf, 0, i);
                        }
                        if (!this.destination.exists() || !FilePermission.canSetPermissions()) return;
                        String permissions = FileManager.getFileSystemPermissions(objectFile);
                        FilePermission.setPermissions(this.destination, FilePermission.decodeUNIXMode(permissions));
                        return;
                    }
                    catch (Exception e) {
                        Message errMsg = UBIDCommonMessages.ERR_COPYING_FILE.get((Object)objectFile.getAbsolutePath(), (Object)this.destination.getAbsolutePath(), (Object)e.getMessage());
                        throw new FileException(errMsg, (Throwable)e);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (FileManager.this.fileDigest != null) {
                            try {
                                String cs1 = FileManager.this.fileDigest.hexStringForFile(objectFile);
                                String cs2 = FileManager.this.fileDigest.hexStringForFile(this.destination);
                                if (!cs1.equals(cs2)) {
                                    Message errMsg = UBIDCommonMessages.ERR_COPYING_FILE.get((Object)objectFile.getAbsolutePath(), (Object)this.destination.getAbsolutePath(), (Object)UBIDCommonMessages.ERR_INFO_FM_CHECKSUM_ERROR.get());
                                    throw new FileException(errMsg, null);
                                }
                            }
                            catch (IOException e) {
                                LOG.log(Level.WARNING, "Error verifying checksums of " + objectFile.getPath() + " and " + this.destination.getPath());
                            }
                        }
                    }
                }
                Message errMsg = UBIDCommonMessages.ERR_COPYING_FILE.get((Object)objectFile.getAbsolutePath(), (Object)this.destination.getAbsolutePath(), (Object)UBIDCommonMessages.ERR_FILE_PARENT_CREATION_FAILED.get((Object)this.destination.getPath()));
                throw new FileException(errMsg, null);
            }
            LOG.log(Level.INFO, "Ignoring file '" + objectFile.getAbsolutePath() + "' since '" + this.destination.getAbsolutePath() + "' already exists");
        }
    }

    private abstract class FileOperation {
        private File objectFile = null;

        public FileOperation(File objectFile) {
            this.objectFile = objectFile;
        }

        protected File getObjectFile() {
            return this.objectFile;
        }

        public abstract FileOperation copyForChild(File var1);

        public abstract void apply() throws FileException;
    }

    public static enum DeletionPolicy {
        DELETE_IMMEDIATELY,
        DELETE_ON_EXIT,
        DELETE_ON_EXIT_IF_UNSUCCESSFUL;

    }
}

