/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProcessStreamReader {
    private final Reader reader;
    private final Appendable outputBuffer;
    private final Thread thread;
    private final AtomicBoolean processIsRunning = new AtomicBoolean(true);
    private volatile Exception exception;

    public ProcessStreamReader(InputStream stream, Appendable outputBuffer) {
        this(stream, outputBuffer, "Process Stream Reader");
    }

    public ProcessStreamReader(InputStream stream, Appendable outputBuffer, String threadName) {
        this.reader = new BufferedReader(new InputStreamReader(stream));
        this.outputBuffer = outputBuffer;
        this.thread = new Thread(threadName){

            @Override
            public void run() {
                ProcessStreamReader.this.readUntilDone();
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void readFullyAndClose() throws InterruptedException {
        this.processIsRunning.set(false);
        this.thread.join();
    }

    public Exception getException() {
        return this.exception;
    }

    private void readUntilDone() {
        try {
            do {
                Thread.sleep(10L);
                while (this.reader.ready()) {
                    int ch = this.reader.read();
                    if (ch == -1) {
                        return;
                    }
                    this.outputBuffer.append((char)ch);
                }
            } while (this.processIsRunning.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

