/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.util.tools.ToolConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;

public class RecordingBufferedReader
extends BufferedReader {
    private Writer archiveWriter;

    public RecordingBufferedReader(Reader in, File archiveFile) throws IOException {
        super(in);
        this.archiveWriter = new FileWriter(archiveFile);
    }

    public void record(String text) throws IOException {
        this.archiveWriter.write(text);
        this.archiveWriter.flush();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.archiveWriter.write(b);
        this.archiveWriter.flush();
        return b;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        this.archiveWriter.write(cbuf, off, read);
        this.archiveWriter.flush();
        return read;
    }

    @Override
    public String readLine() throws IOException {
        String s = super.readLine();
        this.archiveWriter.append(s);
        this.archiveWriter.append(ToolConstants.EOL);
        this.archiveWriter.flush();
        return s;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return super.ready();
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.archiveWriter.close();
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int read = super.read(target);
        this.archiveWriter.write(target.toString());
        this.archiveWriter.flush();
        return read;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int read = super.read(cbuf);
        this.archiveWriter.write(cbuf, 0, read);
        this.archiveWriter.flush();
        return read;
    }
}

