/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.debug.CommonDebugTracer;
import com.unboundid.common.debug.DebugLogLevel;
import com.unboundid.common.debug.DebugLogger;
import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.types.OperatingSystem;
import com.unboundid.messages.Message;
import com.unboundid.util.Validator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SystemUtils {
    public static final String PROPERTY_DISABLE_EXEC = "com.unboundid.directory.server.DisableExec";
    private static final CommonDebugTracer TRACER = DebugLogger.getTracer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String invoke(String ... command) throws IOException {
        int count;
        int BUFFER_SIZE = 2048;
        byte[] dataArray = new byte[2048];
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        InputStream is = process.getInputStream();
        ByteArrayOutputStream commandOutput = new ByteArrayOutputStream();
        while (-1 != (count = is.read(dataArray, 0, 2048))) {
            commandOutput.write(dataArray, 0, count);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return commandOutput.toString();
    }

    public static int exec(String command, String[] args, File workingDirectory, Map<String, String> environment, List<String> output) throws IOException, SecurityException, InterruptedException {
        if (!SystemUtils.mayUseExec()) {
            Message message = UBIDCommonMessages.ERR_EXEC_DISABLED.get((Object)String.valueOf(command));
            throw new SecurityException(message.toString());
        }
        ArrayList<String> commandAndArgs = new ArrayList<String>();
        commandAndArgs.add(command);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                commandAndArgs.add(arg);
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(commandAndArgs);
        processBuilder.redirectErrorStream(true);
        if (workingDirectory != null && workingDirectory.isDirectory()) {
            processBuilder.directory(workingDirectory);
        }
        if (environment != null && !environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        Process process = processBuilder.start();
        InputStream processStream = process.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(processStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (output == null) continue;
                output.add(line);
            }
        }
        catch (IOException ioe) {
            block18: {
                try {
                    process.destroy();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            throw ioe;
        }
        finally {
            block19: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (!DebugLogger.debugEnabled()) break block19;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return process.waitFor();
    }

    public static boolean mayUseExec() {
        return !SystemUtils.disableExec();
    }

    public static boolean disableExec() {
        String disableStr = System.getProperty(PROPERTY_DISABLE_EXEC);
        if (disableStr == null) {
            return false;
        }
        return disableStr.equalsIgnoreCase("true");
    }

    public static File getJdkBinDirectory() {
        String javaHome = System.getProperty("java.home");
        String jdkBinaryFileName = SystemUtils.isUnixBasedOs() ? "jdb" : "jps.exe";
        File jdkBinDir = new File(javaHome, "bin");
        File jps = new File(jdkBinDir, jdkBinaryFileName);
        if (!jps.exists() && !(jps = new File(jdkBinDir = new File(javaHome, "../bin"), jdkBinaryFileName)).exists()) {
            jdkBinDir = null;
        }
        return jdkBinDir;
    }

    public static boolean isUnixBasedOs() {
        return OperatingSystem.isUNIXBased(OperatingSystem.local());
    }

    public static boolean isWindows() {
        return OperatingSystem.local() == OperatingSystem.WINDOWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocalHostName(String hostName) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(true);
            serverSocket.bind(new InetSocketAddress(hostName, 0));
            serverSocket.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean areNamesOfSameHost(String hostName1, String hostName2) {
        Validator.ensureNotNull((Object)hostName1, (Object)hostName2);
        if (hostName1.equals(hostName2)) {
            return true;
        }
        try {
            InetAddress[] addrs1 = InetAddress.getAllByName(hostName1);
            InetAddress[] addrs2 = InetAddress.getAllByName(hostName2);
            for (InetAddress addr1 : addrs1) {
                for (InetAddress addr2 : addrs2) {
                    if (!addr1.equals(addr2)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isUnixCommandAvailable(String cmd) throws IOException {
        boolean available;
        ProcessBuilder pb = new ProcessBuilder("which", cmd);
        pb.redirectErrorStream(true);
        Process process = pb.start();
        try {
            BufferedReader reader;
            String line;
            boolean bl = available = process.waitFor() == 0;
            if (available && OperatingSystem.SOLARIS.equals((Object)OperatingSystem.local()) && ((line = (reader = new BufferedReader(new InputStreamReader(process.getInputStream()))).readLine()) == null || line.startsWith("no"))) {
                available = false;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return available;
    }

    public static int waitFor(Process process) throws InterruptedException {
        if (SystemUtils.isWindows()) {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            try {
                bw.write(13);
                bw.flush();
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return process.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPortInUse(String hostname, int port) {
        boolean portInUse;
        ServerSocket serverSocket = null;
        try {
            InetSocketAddress socketAddress = hostname != null ? new InetSocketAddress(hostname, port) : new InetSocketAddress(port);
            serverSocket = new ServerSocket();
            if (!SystemUtils.isWindows()) {
                serverSocket.setReuseAddress(true);
            }
            serverSocket.bind(socketAddress);
            portInUse = false;
            serverSocket.close();
            Socket s = null;
            s = new Socket();
            s.connect(socketAddress, 1000);
            portInUse = true;
            if (s == null) return portInUse;
            try {
                s.close();
                return portInUse;
            }
            catch (Throwable throwable) {}
            return portInUse;
            catch (Throwable throwable) {
                if (s == null) return portInUse;
                try {
                    s.close();
                    return portInUse;
                }
                catch (Throwable throwable2) {}
                return portInUse;
                catch (Throwable throwable3) {
                    if (s == null) throw throwable3;
                    try {
                        s.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        // empty catch block
                    }
                    throw throwable3;
                }
            }
        }
        catch (IOException ioe) {
            portInUse = true;
            return portInUse;
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean isSuitableHostName(String hostname, List<Message> warnings) {
        if (warnings == null) {
            warnings = new ArrayList<Message>();
        }
        int originalSize = warnings.size();
        try {
            InetAddress address = InetAddress.getByName(hostname);
            if (address != null && address.isLoopbackAddress() || hostname.equalsIgnoreCase("localhost") || hostname.startsWith("127.")) {
                warnings.add(UBIDCommonMessages.WARN_LOCAL_HOST_NAME.get((Object)hostname, (Object)address.getHostAddress()));
            } else if (hostname.indexOf(46) == -1) {
                warnings.add(UBIDCommonMessages.WARN_NOT_FULLY_QUALIFIED_HOST_NAME.get((Object)hostname));
            }
        }
        catch (UnknownHostException e) {
            warnings.add(UBIDCommonMessages.WARN_UNRESOLVABLE_HOST_NAME.get((Object)hostname));
        }
        return originalSize == warnings.size();
    }

    public static String hostPort(String host, Integer port) {
        return SystemUtils.hostPort(host, port != null ? port.toString() : null);
    }

    public static String hostPort(String host, String port) {
        StringBuilder sb = new StringBuilder();
        if (host == null || host.isEmpty()) {
            sb.append("*");
        } else {
            sb.append(SystemUtils.formatIfIPv6(host));
        }
        if (port != null) {
            try {
                int nPort = new Integer(port);
                if (nPort >= 0 && nPort <= 65535) {
                    sb.append(":").append(port);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public static int getPortIndex(String hostPort) {
        int index = -1;
        if (hostPort != null) {
            index = hostPort.startsWith("[") && hostPort.contains("]") ? hostPort.indexOf(":", hostPort.indexOf("]")) : hostPort.indexOf(":");
        }
        return index;
    }

    public static Integer getPort(String hostPort) {
        int index = SystemUtils.getPortIndex(hostPort);
        if (index > -1) {
            try {
                return Integer.valueOf(hostPort.substring(index + 1));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public static String formatIfIPv6(String host) {
        if (host != null && host.contains(":")) {
            if (!(host = host.trim()).startsWith("[")) {
                host = "[" + host;
            }
            if (!host.endsWith("]")) {
                host = host + "]";
            }
        }
        return host;
    }
}

