/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util;

import com.unboundid.common.util.CaseConverter;
import com.unboundid.common.util.tools.ToolConstants;
import com.unboundid.messages.Message;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;

public class TextUtils {
    public static String wrapText(Message message) {
        return TextUtils.wrapText(Message.toString((Message)message), ToolConstants.MAX_LINE_WIDTH, 0);
    }

    public static String wrapText(String text) {
        return TextUtils.wrapText(text, ToolConstants.MAX_LINE_WIDTH, 0);
    }

    public static String wrapText(Message message, int width) {
        return TextUtils.wrapText(Message.toString((Message)message), width, 0);
    }

    public static String wrapText(String text, int width) {
        return TextUtils.wrapText(text, width, 0);
    }

    public static String wrapText(Message message, int width, int indent) {
        return TextUtils.wrapText(Message.toString((Message)message), width, indent);
    }

    public static String wrapText(String text, int width, int indent) {
        return TextUtils.wrapText(text, null, width, indent);
    }

    public static String wrapText(String text, String linePrefix, int width, int indent) {
        return TextUtils.wrapText(text, linePrefix, null, width, indent);
    }

    public static String wrapText(String text, String linePrefix, String lineSeparator, int width, int indent) {
        if (lineSeparator == null) {
            lineSeparator = ToolConstants.EOL;
        }
        width -= indent;
        StringBuilder pb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            pb.append(' ');
        }
        if (linePrefix != null) {
            width -= linePrefix.length();
            pb.append(linePrefix);
        }
        String padding = pb.toString();
        StringBuilder buffer = new StringBuilder();
        if (text != null) {
            StringTokenizer lineTokenizer = new StringTokenizer(text, "\r\n", true);
            while (lineTokenizer.hasMoreTokens()) {
                String line = lineTokenizer.nextToken();
                if (line.equals("\r") || line.equals("\n")) {
                    buffer.append(line);
                    continue;
                }
                if (line.length() < width) {
                    buffer.append(padding);
                    buffer.append(line);
                    continue;
                }
                String leadingSpace = line.replaceAll("\\S.*", "");
                line = line.substring(leadingSpace.length(), line.length());
                StringBuilder lineBuffer = new StringBuilder();
                StringBuilder delimBuffer = new StringBuilder();
                StringTokenizer wordTokenizer = new StringTokenizer(line, " ", true);
                lineBuffer.append(leadingSpace);
                while (wordTokenizer.hasMoreTokens()) {
                    String word = wordTokenizer.nextToken();
                    if (word.equals(" ")) {
                        if (lineBuffer.length() <= 0) continue;
                        delimBuffer.append(word);
                        continue;
                    }
                    if (word.length() > width) {
                        if (lineBuffer.length() > 0) {
                            buffer.append(padding);
                            buffer.append((CharSequence)lineBuffer);
                            buffer.append(lineSeparator);
                            lineBuffer = new StringBuilder();
                            lineBuffer.append(leadingSpace);
                        }
                        buffer.append(padding);
                        buffer.append(word);
                        if (wordTokenizer.hasMoreTokens()) {
                            wordTokenizer.nextToken();
                            if (wordTokenizer.hasMoreTokens()) {
                                buffer.append(lineSeparator);
                            }
                        }
                        if (delimBuffer.length() <= 0) continue;
                        delimBuffer = new StringBuilder();
                        continue;
                    }
                    int newLineLength = lineBuffer.length() + delimBuffer.length() + word.length();
                    if (newLineLength < width) {
                        lineBuffer.append((CharSequence)delimBuffer).append(word);
                        if (delimBuffer.length() <= 0) continue;
                        delimBuffer = new StringBuilder();
                        continue;
                    }
                    buffer.append(padding);
                    buffer.append((CharSequence)lineBuffer);
                    buffer.append(lineSeparator);
                    lineBuffer = new StringBuilder();
                    lineBuffer.append(leadingSpace);
                    lineBuffer.append(word);
                    if (delimBuffer.length() <= 0) continue;
                    delimBuffer = new StringBuilder();
                }
                buffer.append(padding);
                buffer.append((CharSequence)lineBuffer);
            }
        }
        return buffer.toString();
    }

    public static String capitalize(String string) {
        if (string != null && string.length() > 0) {
            StringBuilder sb = new StringBuilder().append(Character.toUpperCase(string.charAt(0)));
            if (string.length() > 1) {
                sb.append(string.substring(1));
            }
            return sb.toString();
        }
        return string;
    }

    public static String upperCamelCase(String lcc, Set<String> abbreviations) {
        if (lcc != null && !lcc.isEmpty()) {
            StringBuilder tokenBuilder = new StringBuilder();
            for (int i = 0; i < lcc.length(); ++i) {
                if (Character.isUpperCase(lcc.charAt(i))) {
                    String token = tokenBuilder.toString();
                    if (abbreviations != null && abbreviations.contains(token.toUpperCase())) {
                        return token.toUpperCase() + lcc.substring(i);
                    }
                    return TextUtils.capitalize(token) + lcc.substring(i);
                }
                tokenBuilder.append(lcc.charAt(i));
            }
            return lcc.toUpperCase();
        }
        return lcc;
    }

    public static String camelCaseToHyphenCase(String string, Set<String> abbreviations) {
        return new CaseConverter(abbreviations).camelToHyphen(string);
    }

    public static String hyphenCaseToLowerCamelCase(String string, Set<String> abbreviations) {
        return new CaseConverter(abbreviations).hyphenToLowerCamel(string);
    }

    public static String hyphenCaseToUpperCamelCase(String string, Set<String> abbreviations) {
        return new CaseConverter(abbreviations).hyphenToUpperCamel(string);
    }

    public static String[] splitHyphens(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : string.split("-")) {
            if (token.isEmpty()) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }
}

