/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.RecordingBufferedReader;
import com.unboundid.common.util.TestUtils;
import com.unboundid.common.util.TextUtils;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.IntegerValidationCallback;
import com.unboundid.common.util.cli.MenuCallback;
import com.unboundid.common.util.cli.MenuResult;
import com.unboundid.common.util.cli.PortValidationCallback;
import com.unboundid.common.util.cli.ValidationCallback;
import com.unboundid.common.util.tools.ToolConstants;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import com.unboundid.util.NullOutputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleInteraction {
    private PrintStream err;
    protected BufferedReader in;
    protected PrintStream out;
    protected static final int CONFIRMATION_MAX_TRIES = 5;
    private int nChars = 0;
    private String lastPrinted;

    public static void checkUnitTests() {
        if (TestUtils.isWithinUnitTest() && !TestUtils.permitInteractiveTests()) {
            throw new RuntimeException("Unexpected user interaction during unit test");
        }
    }

    public ConsoleInteraction(BufferedReader in, PrintStream out, PrintStream err) {
        this.in = in != null ? in : new BufferedReader(new NullReader());
        this.out = out != null ? out : NullOutputStream.getPrintStream();
        this.err = err != null ? out : NullOutputStream.getPrintStream();
    }

    public ConsoleInteraction() {
        this(System.in, (OutputStream)System.out, (OutputStream)System.err);
    }

    public ConsoleInteraction(InputStream in, OutputStream out, OutputStream err) {
        this.in = in != null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new NullReader());
        this.out = out != null ? new PrintStream(out) : NullOutputStream.getPrintStream();
        this.err = err != null ? new PrintStream(err) : NullOutputStream.getPrintStream();
    }

    public boolean confirmAction(Message prompt, final boolean defaultValue) throws CLIException {
        final Message yes = UBIDCommonMessages.INFO_GENERAL_YES.get();
        final Message no = UBIDCommonMessages.INFO_GENERAL_NO.get();
        final Message errMsg = UBIDCommonMessages.ERR_CONSOLE_APP_CONFIRM.get((Object)yes, (Object)no);
        prompt = UBIDCommonMessages.INFO_MENU_PROMPT_CONFIRM.get((Object)prompt, (Object)yes, (Object)no, (Object)(defaultValue ? yes : no));
        ValidationCallback<Boolean> validator = new ValidationCallback<Boolean>(){

            @Override
            public Boolean validate(ConsoleInteraction app, String input) {
                String ninput = input.toLowerCase().trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                if (no.toString().startsWith(ninput)) {
                    return false;
                }
                if (yes.toString().startsWith(ninput)) {
                    return true;
                }
                app.println();
                app.println(errMsg);
                app.println();
                return null;
            }
        };
        return this.readValidatedInput(prompt, validator, 5);
    }

    public final PrintStream getErrorStream() {
        return this.err;
    }

    public final void setErrorStream(OutputStream errStream) {
        this.err = errStream == null ? NullOutputStream.getPrintStream() : (errStream instanceof PrintStream ? (PrintStream)errStream : new PrintStream(errStream));
    }

    public final BufferedReader getInputStream() {
        return this.in;
    }

    public final void setInputStream(BufferedReader in) {
        if (in != null) {
            this.in = in;
        }
    }

    public final void setInputStream(InputStream in) {
        if (in != null) {
            this.in = new BufferedReader(new InputStreamReader(in));
        }
    }

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public final void setOutStream(OutputStream outStream) {
        this.out = outStream == null ? NullOutputStream.getPrintStream() : (outStream instanceof PrintStream ? (PrintStream)outStream : new PrintStream(outStream));
    }

    public String getLastPrinted() {
        return this.lastPrinted;
    }

    public void pressReturnToContinue() {
        Message msg = UBIDCommonMessages.INFO_MENU_PROMPT_RETURN_TO_CONTINUE.get();
        try {
            this.readLineOfInput(msg);
        }
        catch (CLIException cLIException) {
            // empty catch block
        }
    }

    public void println() {
        this.printlnOut();
    }

    public void println(String string) {
        this.printlnOut(string);
    }

    public void print(String string) {
        this.printOut(string);
    }

    public void println(Message msg) {
        if (msg != null && msg.isError()) {
            this.printlnErr(TextUtils.wrapText(msg));
        } else {
            this.println(TextUtils.wrapText(msg));
        }
    }

    public void print(Message msg) {
        if (msg != null && msg.isError()) {
            this.printErr(TextUtils.wrapText(msg));
        } else {
            this.print(TextUtils.wrapText(msg));
        }
    }

    public void println(Message msg, int indent) {
        this.println(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public void println(String msg, int indent) {
        this.println(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public void println(List<String> lines) {
        if (lines != null) {
            for (String s : lines) {
                this.printlnOut(s);
            }
        }
    }

    public void print(List<String> lines) {
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                if (i == lines.size() - 1) {
                    this.printOut(lines.get(i));
                    continue;
                }
                this.printlnOut(lines.get(i));
            }
        }
    }

    public void printlnErr() {
        this.err.println();
        this.lastPrinted = "\n";
        this.nChars += ToolConstants.EOL.length();
    }

    public void printlnErr(String string) {
        this.err.println(string);
        this.lastPrinted = String.valueOf(string) + "\n";
        this.nChars = this.nChars + String.valueOf(string).length() + ToolConstants.EOL.length();
    }

    public void printErr(String string) {
        this.err.print(string);
        this.lastPrinted = String.valueOf(string);
        this.nChars += String.valueOf(string).length();
    }

    public void printlnErr(Message msg) {
        this.printlnErr(TextUtils.wrapText(msg));
    }

    public void printlnErr(List<String> lines) {
        if (lines != null) {
            for (String line : lines) {
                this.printlnErr(line);
            }
        }
    }

    public void printErr(Message msg) {
        this.printErr(TextUtils.wrapText(msg));
    }

    public void printErr(List<String> lines) {
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                if (i == lines.size() - 1) {
                    this.printErr(lines.get(i));
                    continue;
                }
                this.printlnErr(lines.get(i));
            }
        }
    }

    public void printlnErr(Message msg, int indent) {
        this.printlnErr(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public void printlnErr(List<String> lines, int indent) {
        if (lines != null) {
            StringBuilder indentBuf = new StringBuilder(indent);
            for (int i = 0; i < indent; ++i) {
                indentBuf.append(' ');
            }
            String indentStr = indentBuf.toString();
            for (String s : lines) {
                this.printErr(indentStr);
                this.printlnErr(s);
            }
        }
    }

    public void printlnErr(String msg, int indent) {
        this.printlnErr(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public void printlnOut() {
        this.out.println();
        this.lastPrinted = "\n";
        this.nChars += ToolConstants.EOL.length();
    }

    public void printlnOut(String string) {
        this.out.println(string);
        this.lastPrinted = String.valueOf(string) + "\n";
        this.nChars = this.nChars + String.valueOf(string).length() + ToolConstants.EOL.length();
    }

    public void printOut(String string) {
        this.out.print(string);
        this.lastPrinted = String.valueOf(string);
        this.nChars += String.valueOf(string).length();
    }

    public void printlnOut(Message msg) {
        this.printlnOut(TextUtils.wrapText(msg));
    }

    public void printlnOut(List<String> lines) {
        if (lines != null) {
            for (String line : lines) {
                this.printlnOut(line);
            }
        }
    }

    public void printOut(Message msg) {
        this.printOut(TextUtils.wrapText(msg));
    }

    public void printOut(List<String> lines) {
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                if (i == lines.size() - 1) {
                    this.printOut(lines.get(i));
                    continue;
                }
                this.printlnOut(lines.get(i));
            }
        }
    }

    public void printlnOut(Message msg, int indent) {
        this.printlnOut(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public void printlnOut(List<String> lines, int indent) {
        if (lines != null) {
            StringBuilder indentBuf = new StringBuilder(indent);
            for (int i = 0; i < indent; ++i) {
                indentBuf.append(' ');
            }
            String indentStr = indentBuf.toString();
            for (String s : lines) {
                this.printOut(indentStr);
                this.printlnOut(s);
            }
        }
    }

    public void printlnOut(String msg, int indent) {
        this.printlnOut(TextUtils.wrapText(msg, ToolConstants.MAX_LINE_WIDTH, indent));
    }

    public String readLineOfInput(Message prompt) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        if (prompt != null) {
            this.print(TextUtils.wrapText(prompt));
            this.print(" ");
        }
        try {
            String s = this.in.readLine();
            if (s == null) {
                throw CLIException.adaptInputException(new EOFException("End of input"));
            }
            return s;
        }
        catch (IOException e) {
            throw CLIException.adaptInputException(e);
        }
    }

    public <T> T readValue(Message prompt, ValidationCallback<MenuCallback<T>> validator) throws CLIException {
        return this.readValue(prompt, null, validator);
    }

    public <T> T readValue(Message prompt, String defaultValue, ValidationCallback<MenuCallback<T>> validator) throws CLIException {
        MenuResult<T> result;
        ConsoleInteraction.checkUnitTests();
        T value = null;
        do {
            this.println();
            String input = this.readLineOfInput(prompt);
            if (input == null || input.isEmpty()) {
                input = defaultValue;
            }
            if (input == null || input.isEmpty()) break;
            MenuCallback<T> callback = validator.validate(this, input);
            result = callback.invoke(this);
            if (!result.isSuccess()) continue;
            value = result.getValue();
        } while (result.isAgain());
        return value;
    }

    public String readInput(Message prompt, String defaultValue) throws CLIException {
        String response;
        block4: {
            ConsoleInteraction.checkUnitTests();
            while (true) {
                if (defaultValue != null) {
                    prompt = UBIDCommonMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt.toString(), (Object)defaultValue);
                } else {
                    String promptString = prompt.toString();
                    if (!promptString.endsWith(":")) {
                        prompt = new MessageBuilder(promptString).append(':').toMessage();
                    }
                }
                response = this.readLineOfInput(prompt);
                if (!"".equals(response)) break block4;
                if (defaultValue != null) break;
                this.println(UBIDCommonMessages.INFO_ERROR_EMPTY_RESPONSE.get());
            }
            return defaultValue;
        }
        return response;
    }

    public String readInput(Message prompt, String defaultValue, Logger logger) {
        ConsoleInteraction.checkUnitTests();
        String s = defaultValue;
        try {
            s = this.readInput(prompt, defaultValue);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    public String readPassword(Message prompt) throws CLIException {
        char[] pwChars;
        ConsoleInteraction.checkUnitTests();
        if (null == System.getProperty("com.unboundid.directory.server.util.cli.NoPasswordMasking")) {
            this.print(TextUtils.wrapText(prompt + " "));
            try {
                Console console = System.console();
                if (console != null) {
                    pwChars = System.console().readPassword();
                }
                String line = this.in.readLine();
                if (line != null) {
                    pwChars = line.toCharArray();
                }
                pwChars = new char[]{};
            }
            catch (Exception e) {
                throw CLIException.adaptInputException(e);
            }
        } else {
            pwChars = this.readInput(prompt, null).toCharArray();
        }
        if (this.in instanceof RecordingBufferedReader) {
            try {
                ((RecordingBufferedReader)this.in).record(new MessageBuilder(UBIDCommonMessages.INFO_MASKED_TEXT.get()).append((CharSequence)"\n").toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String(pwChars);
    }

    public DN promptDn(Message prompt, String defaultDn) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        DN dn = null;
        while (dn == null) {
            String input = null;
            try {
                input = this.readInput(prompt, defaultDn);
                dn = new DN(input);
            }
            catch (LDAPException e) {
                this.println();
                if (!this.confirmAction(UBIDCommonMessages.ERR_DN_PARSE_ERROR.get((Object)input), true)) {
                    return null;
                }
                this.println();
            }
        }
        return dn;
    }

    protected final String readPassword(Message prompt, Logger logger) {
        ConsoleInteraction.checkUnitTests();
        String pwd = null;
        try {
            pwd = this.readPassword(prompt);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return pwd;
    }

    public final int readPort(Message prompt, Integer defaultValue) throws CLIException {
        return this.readPort(prompt, defaultValue, null);
    }

    public final int readPort(Message prompt, Integer defaultValue, Set<Integer> unavailableValues) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        PortValidationCallback callback = new PortValidationCallback(PortValidationCallback.WarningMode.NONE, null);
        callback.setUnavailablePorts(unavailableValues);
        if (defaultValue != null && defaultValue != -1) {
            prompt = UBIDCommonMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt.toString(), (Object)String.valueOf(defaultValue));
        }
        String defaultPort = defaultValue != null ? defaultValue.toString() : null;
        return this.readValidatedInput(prompt, defaultPort, callback);
    }

    public final int readPort(Message prompt, Integer defaultValue, Set<Integer> unavailableValues, PortValidationCallback.WarningMode warningMode) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        if (warningMode == null) {
            warningMode = PortValidationCallback.WarningMode.NONE;
        }
        PortValidationCallback callback = new PortValidationCallback(warningMode, null);
        callback.setUnavailablePorts(unavailableValues);
        if (defaultValue != null && defaultValue != -1) {
            prompt = UBIDCommonMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt.toString(), (Object)String.valueOf(defaultValue));
        }
        String defaultPort = defaultValue != null ? defaultValue.toString() : null;
        return this.readValidatedInput(prompt, defaultPort, callback);
    }

    public final int readInteger(Message prompt, Integer defaultValue) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        IntegerValidationCallback callback = new IntegerValidationCallback();
        if (defaultValue != null && defaultValue != -1) {
            prompt = UBIDCommonMessages.INFO_PROMPT_SINGLE_DEFAULT.get((Object)prompt.toString(), (Object)String.valueOf(defaultValue));
        }
        String defaultPort = defaultValue != null ? defaultValue.toString() : null;
        return this.readValidatedInput(prompt, defaultPort, callback);
    }

    public <T> T readValidatedInput(Message prompt, String defaultValue, ValidationCallback<T> validator) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        while (true) {
            T value;
            String response;
            if ((response = this.readLineOfInput(prompt)) == null || response.length() == 0) {
                response = defaultValue;
            }
            if ((value = validator.validate(this, response)) != null) {
                return value;
            }
            this.println();
        }
    }

    public <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        return this.readValidatedInput(prompt, "", validator);
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator, int maxTries) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        for (int nTries = 0; nTries < maxTries; ++nTries) {
            String response = this.readLineOfInput(prompt);
            T value = validator.validate(this, response);
            if (value == null) continue;
            return value;
        }
        throw new CLIException(UBIDCommonMessages.ERR_TRIES_LIMIT_REACHED.get((Object)maxTries));
    }

    protected final boolean askConfirmation(Message prompt, boolean defaultValue, Logger logger) throws CLIException {
        ConsoleInteraction.checkUnitTests();
        boolean v = defaultValue;
        boolean done = false;
        int nTries = 0;
        while (!done && nTries < 5) {
            ++nTries;
            try {
                v = this.confirmAction(prompt, defaultValue);
                done = true;
            }
            catch (CLIException ce) {
                if (ce.getMessageObject().getDescriptor().equals(UBIDCommonMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED) || ce.getMessageObject().getDescriptor().equals(UBIDCommonMessages.ERR_TRIES_LIMIT_REACHED)) {
                    throw ce;
                }
                logger.log(Level.WARNING, "Error reading input: " + ce, ce);
                this.println();
            }
        }
        if (!done) {
            throw new CLIException(UBIDCommonMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get((Object)5));
        }
        return v;
    }

    public int getNumberOfErrorCharactersWritten() {
        return this.nChars;
    }

    protected static final class NullReader
    extends Reader {
        protected NullReader() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return -1;
        }
    }
}

