/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.ValidationCallback;
import java.io.File;

public class FilePathValidationCallback
implements ValidationCallback<File> {
    private final boolean fileMustExist;
    private final FileType fileType;
    private final boolean parentMustExist;
    private final boolean createIfDoesNotExist;
    private File relativeBaseDirectory;

    public FilePathValidationCallback(FileType fileType, boolean fileMustExist, boolean parentMustExist, boolean createIfDoesNotExist) {
        this.fileType = fileType;
        this.fileMustExist = fileMustExist;
        this.parentMustExist = parentMustExist;
        this.createIfDoesNotExist = createIfDoesNotExist;
        if (createIfDoesNotExist && fileType != FileType.FILE && fileType != FileType.DIRECTORY) {
            throw new RuntimeException("Cannot create a file of unspecified type");
        }
    }

    public boolean fileMustExist() {
        return this.fileMustExist;
    }

    public boolean parentMustExist() {
        return this.parentMustExist;
    }

    public boolean mustBeFile() {
        return this.fileType == FileType.FILE;
    }

    public boolean mustBeDirectory() {
        return this.fileType == FileType.DIRECTORY;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public File getRelativeBaseDirectory() {
        return this.relativeBaseDirectory;
    }

    public void setRelativeBaseDirectory(File relativeBaseDirectory) {
        this.relativeBaseDirectory = relativeBaseDirectory;
    }

    @Override
    public File validate(ConsoleInteraction app, String rawInput) throws CLIException {
        File f;
        block16: {
            String input = rawInput == null ? null : rawInput.trim();
            f = new File(input);
            if (!f.isAbsolute()) {
                f = this.relativeBaseDirectory == null ? new File(f.getAbsolutePath()) : new File(new File(this.relativeBaseDirectory, input).getAbsolutePath());
            }
            if (f.exists()) {
                if (this.mustBeFile() && !f.isFile()) {
                    app.println();
                    app.println(UBIDCommonMessages.ERR_FILE_VALUE_NOT_FILE.get((Object)f.getAbsolutePath()));
                    return null;
                }
                if (this.mustBeDirectory() && !f.isDirectory()) {
                    app.println();
                    app.println(UBIDCommonMessages.ERR_FILE_VALUE_NOT_DIRECTORY.get((Object)f.getAbsolutePath()));
                    return null;
                }
            } else {
                File parentFile;
                if (this.fileMustExist) {
                    app.println();
                    app.println(UBIDCommonMessages.ERR_FILE_DOESNT_EXIST.get((Object)f.getAbsolutePath()));
                    return null;
                }
                if (!(!this.parentMustExist || (parentFile = f.getParentFile()) != null && parentFile.exists() && parentFile.isDirectory())) {
                    app.println();
                    app.println(UBIDCommonMessages.ERR_FILE_PARENT_DOESNT_EXIST.get((Object)f.getAbsolutePath()));
                    return null;
                }
                if (this.createIfDoesNotExist) {
                    if (this.mustBeFile()) {
                        try {
                            if (!f.createNewFile()) {
                                app.println();
                                app.println(UBIDCommonMessages.ERR_FILE_COULD_NOT_CREATE_FILE.get((Object)f.getAbsolutePath()));
                                return null;
                            }
                            break block16;
                        }
                        catch (Exception e) {
                            app.println();
                            app.println(UBIDCommonMessages.ERR_FILE_ERROR_CREATING_FILE.get((Object)f.getAbsolutePath(), (Object)e.getMessage()));
                            return null;
                        }
                    }
                    if (this.mustBeDirectory()) {
                        try {
                            if (!f.mkdir()) {
                                app.println();
                                app.println(UBIDCommonMessages.ERR_FILE_COULD_NOT_CREATE_FILE.get((Object)f.getAbsolutePath()));
                                return null;
                            }
                        }
                        catch (Exception e) {
                            app.println();
                            app.println(UBIDCommonMessages.ERR_FILE_ERROR_CREATING_FILE.get((Object)f.getAbsolutePath(), (Object)e.getMessage()));
                            return null;
                        }
                    }
                }
            }
        }
        return f;
    }

    public static enum FileType {
        FILE,
        DIRECTORY,
        FILE_OR_DIRECTORY;

    }
}

