/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.ValidationCallback;
import java.net.MalformedURLException;
import java.net.URL;

public class HTTPURLValidationCallback
implements ValidationCallback<URL> {
    @Override
    public URL validate(ConsoleInteraction app, String input) throws CLIException {
        URL url;
        try {
            if (input == null) {
                throw new MalformedURLException("You must enter an HTTP URL");
            }
            url = new URL(input);
            String s = url.toString().toLowerCase();
            if (!s.startsWith("http://") && !s.startsWith("https://")) {
                throw new MalformedURLException("The URL must start with 'http://' or 'https://'");
            }
        }
        catch (MalformedURLException e) {
            app.printlnErr(e.getMessage());
            return null;
        }
        return url;
    }
}

