/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.HelpCallback;
import com.unboundid.common.util.cli.Menu;
import com.unboundid.common.util.cli.MenuCallback;
import com.unboundid.common.util.cli.MenuItem;
import com.unboundid.common.util.cli.MenuResult;
import com.unboundid.common.util.cli.TextualMenuCallback;
import com.unboundid.common.util.cli.ValidationCallback;
import com.unboundid.common.util.cli.table.TableBuilder;
import com.unboundid.common.util.cli.table.TextTablePrinter;
import com.unboundid.common.util.tools.ToolConstants;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class MenuBuilder<T> {
    private int threshold = -1;
    private boolean allowMultiSelect = false;
    private final ConsoleInteraction app;
    private final List<MenuCallback<T>> charCallbacks = new ArrayList<MenuCallback<T>>();
    private final List<Message> charKeys = new ArrayList<Message>();
    private final List<Message> charSynopsis = new ArrayList<Message>();
    private final List<Message> columnHeadings = new ArrayList<Message>();
    private final List<Integer> columnWidths = new ArrayList<Integer>();
    private MenuCallback<T> defaultCallback = null;
    private Message defaultDescription = null;
    private ValidationCallback<MenuCallback<T>> defaultValidator;
    private final LinkedHashMap<Message, List<MenuItem<T>>> menuItemsByGroup = new LinkedHashMap();
    private Message title = null;
    private Message prompt = null;
    private Message inputPrompt;
    private int nMaxTries = -1;
    private boolean useDefaultValidatorForDefaultInput = true;
    private int groupLabelPadding = 1;

    public MenuBuilder(ConsoleInteraction app) {
        this.app = app;
    }

    public void setOptionGroupOrder(List<Message> orderedGroupLabels) {
        if (orderedGroupLabels != null) {
            for (Message group : orderedGroupLabels) {
                this.menuItemsByGroup.put(group, null);
            }
        }
    }

    public void setOptionGroupPadding(int rows) {
        this.groupLabelPadding = rows;
    }

    public void addBackOption(boolean isDefault, MenuResult<T> result) {
        this.addCharOption(UBIDCommonMessages.INFO_MENU_OPTION_BACK_KEY.get(), UBIDCommonMessages.INFO_MENU_OPTION_BACK.get(), result);
        if (isDefault) {
            this.setDefault(UBIDCommonMessages.INFO_MENU_OPTION_BACK_KEY.get(), result);
        }
    }

    public void addBackOption(boolean isDefault) {
        this.addCharOption(UBIDCommonMessages.INFO_MENU_OPTION_BACK_KEY.get(), UBIDCommonMessages.INFO_MENU_OPTION_BACK.get(), MenuResult.back());
        if (isDefault) {
            this.setDefault(UBIDCommonMessages.INFO_MENU_OPTION_BACK_KEY.get(), MenuResult.back());
        }
    }

    public void addCancelOption(boolean isDefault) {
        this.addCharOption(UBIDCommonMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), UBIDCommonMessages.INFO_MENU_OPTION_CANCEL.get(), MenuResult.cancel());
        if (isDefault) {
            this.setDefault(UBIDCommonMessages.INFO_MENU_OPTION_CANCEL_KEY.get(), MenuResult.cancel());
        }
    }

    public void addCharOption(Message c, Message description, MenuCallback<T> callback) {
        this.addCharOption(c, description, callback, false);
    }

    public void addCharOption(Message c, Message description, MenuCallback<T> callback, boolean isDefault) {
        this.charKeys.add(c);
        this.charSynopsis.add(description);
        this.charCallbacks.add(callback);
        if (isDefault) {
            this.setDefault(c, callback);
        }
    }

    public void addCharOption(Message c, Message description, MenuResult<T> result) {
        this.addCharOption(c, description, new ResultCallback(result));
    }

    public void addCharOption(Message c, Message description, MenuResult<T> result, boolean isDefault) {
        this.addCharOption(c, description, new ResultCallback(result), isDefault);
    }

    public void addHelpOption(final HelpCallback callback) {
        MenuCallback wrapper = new MenuCallback<T>(){

            @Override
            public MenuResult<T> invoke(ConsoleInteraction app) throws CLIException {
                app.println();
                callback.display(app);
                return MenuResult.again();
            }
        };
        this.addCharOption(UBIDCommonMessages.INFO_MENU_OPTION_HELP_KEY.get(), UBIDCommonMessages.INFO_MENU_OPTION_HELP.get(), wrapper);
    }

    public int addNumberedOption(Message description, MenuCallback<T> callback, Message ... extraFields) {
        return this.addNumberedOption(description, callback, false, extraFields);
    }

    public int addNumberedOption(Message description, MenuCallback<T> callback, Message[] subFields, Message ... extraFields) {
        return this.addNumberedOption(description, callback, false, extraFields);
    }

    public int addNumberedOption(Message description, MenuCallback<T> callback, boolean isDefault, Message ... extraFields) {
        return this.addNumberedOption(description, null, callback, isDefault, Collections.emptyList(), extraFields);
    }

    public int addNumberedOption(Message description, Message groupHeader, MenuCallback<T> callback, boolean isDefault, Message ... extraFields) {
        return this.addNumberedOption(description, groupHeader, callback, isDefault, Collections.emptyList(), extraFields);
    }

    public int addNumberedOption(Message description, Message groupHeader, MenuCallback<T> callback, boolean isDefault, Collection<Message> subFields, Message ... extraFields) {
        List<MenuItem<T>> menuItems;
        ArrayList<Message> fields = new ArrayList<Message>();
        fields.add(description);
        if (extraFields != null) {
            fields.addAll(Arrays.asList(extraFields));
        }
        if ((menuItems = this.menuItemsByGroup.get(groupHeader)) == null) {
            menuItems = new ArrayList<MenuItem<T>>(new ArrayList());
            this.menuItemsByGroup.put(groupHeader, menuItems);
        }
        menuItems.add(new MenuItem<T>(callback, fields, new ArrayList<Message>(subFields)));
        int n = menuItems.size();
        if (isDefault) {
            this.setDefault(Message.fromObject((Object)n, (Object[])new Object[0]), callback);
        }
        return n;
    }

    public int addNumberedOption(Message description, MenuResult<T> result, Message ... extraFields) {
        return this.addNumberedOption(description, new ResultCallback(result), false, extraFields);
    }

    public int addNumberedOption(Message description, MenuResult<T> result, boolean isDefault, Message ... extraFields) {
        return this.addNumberedOption(description, new ResultCallback(result), isDefault, extraFields);
    }

    public void addQuitOption() {
        this.addCharOption(UBIDCommonMessages.INFO_MENU_OPTION_QUIT_KEY.get(), UBIDCommonMessages.INFO_MENU_OPTION_QUIT.get(), MenuResult.quit());
    }

    public void setAllowMultiSelect(boolean allowMultiSelect) {
        this.allowMultiSelect = allowMultiSelect;
    }

    public void setColumnHeadings(Message ... headings) {
        this.columnHeadings.clear();
        if (headings != null) {
            this.columnHeadings.addAll(Arrays.asList(headings));
        }
    }

    public void setColumnWidths(Integer ... widths) {
        this.columnWidths.clear();
        if (widths != null) {
            this.columnWidths.addAll(Arrays.asList(widths));
        }
    }

    public void setDefault(Message description, MenuCallback<T> callback) {
        this.setDefault(description, callback, false);
    }

    public void setDefault(Message description, MenuCallback<T> callback, boolean useDefaultValidator) {
        this.defaultCallback = callback;
        this.defaultDescription = description;
        this.useDefaultValidatorForDefaultInput = useDefaultValidator;
    }

    public void setValidator(final ValidationCallback<T> validator) {
        this.setDefaultValidator(new ValidationCallback<MenuCallback<T>>(){

            @Override
            public MenuCallback<T> validate(ConsoleInteraction app, String input) throws CLIException {
                final Object value = validator.validate(app, input);
                if (value != null) {
                    return new MenuCallback<T>(){

                        @Override
                        public MenuResult<T> invoke(ConsoleInteraction app) throws CLIException {
                            return MenuResult.success(value);
                        }
                    };
                }
                return new MenuCallback<T>(){

                    @Override
                    public MenuResult<T> invoke(ConsoleInteraction app) throws CLIException {
                        return MenuResult.again();
                    }
                };
            }
        });
    }

    public void setDefaultValidator(ValidationCallback<MenuCallback<T>> validator) {
        this.defaultValidator = validator;
    }

    public void setDefault(Message description, MenuResult<T> result) {
        this.setDefault(description, new ResultCallback(result), true);
    }

    public void setMultipleColumnThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setPrompt(Message prompt) {
        this.prompt = prompt;
    }

    public void setInputPrompt(Message prompt) {
        this.inputPrompt = prompt;
    }

    public void setTitle(Message title) {
        this.title = title;
    }

    public Menu<T> toMenu() {
        Integer width;
        LinkedHashMap<Message, TableBuilder> nbuilders = new LinkedHashMap<Message, TableBuilder>();
        HashMap<String, MenuCallback<T>> callbacks = new HashMap<String, MenuCallback<T>>();
        int totalCallbacks = 0;
        for (List<MenuItem<T>> menuItemsForGroup : this.menuItemsByGroup.values()) {
            if (menuItemsForGroup == null) continue;
            totalCallbacks += menuItemsForGroup.size();
        }
        boolean useMultipleColumns = false;
        if (this.threshold >= 0 && totalCallbacks >= this.threshold) {
            useMultipleColumns = true;
        }
        if (this.menuItemsByGroup.get(null) == null && !this.columnHeadings.isEmpty()) {
            TableBuilder builder = new TableBuilder();
            nbuilders.put(null, builder);
            this.appendHeadings(builder, useMultipleColumns);
        }
        int groupOptionStart = 0;
        for (Message group : this.menuItemsByGroup.keySet()) {
            List<MenuItem<T>> menuItemsForGroup = this.menuItemsByGroup.get(group);
            if (menuItemsForGroup == null || menuItemsForGroup.isEmpty()) continue;
            TableBuilder nbuilder = new TableBuilder();
            nbuilders.put(group, nbuilder);
            if (!this.columnHeadings.isEmpty() && group == null) {
                this.appendHeadings(nbuilder, useMultipleColumns);
            }
            LinkedList<List<Object>> leftQueue = new LinkedList<List<Object>>();
            LinkedList rightQueue = new LinkedList();
            int maxSubFieldWidth = ToolConstants.MAX_LINE_WIDTH - 4;
            if (useMultipleColumns) {
                maxSubFieldWidth /= 2;
            }
            maxSubFieldWidth -= 6;
            for (int i = 0; i < menuItemsForGroup.size(); ++i) {
                MenuItem menuItem = (MenuItem)menuItemsForGroup.get(i);
                List<Message> fields = menuItem.fields;
                LinkedList<List<Object>> queue = i <= menuItemsForGroup.size() / 2 || !useMultipleColumns ? leftQueue : rightQueue;
                ArrayList<Message> primaryFields = new ArrayList<Message>();
                primaryFields.add(UBIDCommonMessages.INFO_MENU_NUMERIC_OPTION.get((Object)(i + 1 + groupOptionStart)));
                primaryFields.addAll(fields);
                queue.add(primaryFields);
                int toDisplay = Math.min(menuItem.subFields.size(), 4);
                for (int j = 0; j < toDisplay; ++j) {
                    String subField = menuItem.subFields.get(j).toString();
                    Message toOutput = UBIDCommonMessages.INFO_SUBFIELD_FORMAT.get((Object)subField);
                    if (subField.length() > maxSubFieldWidth) {
                        toOutput = UBIDCommonMessages.INFO_SUBFIELD_FORMAT_ELLIPSES.get((Object)subField.substring(0, maxSubFieldWidth - 4));
                    }
                    queue.add(Arrays.asList(Message.EMPTY, toOutput));
                }
                if (menuItem.subFields.size() >= 5) {
                    queue.add(Arrays.asList(Message.EMPTY, UBIDCommonMessages.INFO_MORE_SUBFIELDS.get()));
                }
                callbacks.put(String.valueOf(i + 1 + groupOptionStart), menuItem.callback);
            }
            while (leftQueue.size() > 0 || rightQueue.size() > 0) {
                nbuilder.startRow();
                if (leftQueue.size() > 0) {
                    for (Message message : (List)leftQueue.poll()) {
                        nbuilder.appendCell(message);
                    }
                }
                if (rightQueue.size() <= 0) continue;
                for (Message message : (List)rightQueue.poll()) {
                    nbuilder.appendCell(message);
                }
            }
            groupOptionStart += menuItemsForGroup.size();
        }
        int column = 0;
        while ((width = this.getMaxWidth(nbuilders.values(), column)) != null) {
            for (TableBuilder builder : nbuilders.values()) {
                builder.setColumnWidth(column, width);
            }
            ++column;
        }
        TableBuilder cbuilder = new TableBuilder();
        for (int i = 0; i < this.charCallbacks.size(); ++i) {
            char c = this.charKeys.get(i).charAt(0);
            Message option = UBIDCommonMessages.INFO_MENU_CHAR_OPTION.get((Object)Character.valueOf(c));
            cbuilder.startRow();
            cbuilder.appendCell(option);
            cbuilder.appendCell(this.charSynopsis.get(i));
            callbacks.put(String.valueOf(c), this.charCallbacks.get(i));
        }
        TextTablePrinter printer = new TextTablePrinter(this.app.getOutputStream());
        if (this.columnHeadings.isEmpty()) {
            printer.setDisplayHeadings(false);
        } else {
            printer.setDisplayHeadings(true);
            printer.setHeadingSeparatorStartColumn(1);
        }
        printer.setIndentWidth(4);
        printer.setShrinkToFit(true);
        if (this.columnWidths.isEmpty()) {
            printer.setColumnWidth(1, 0);
            if (useMultipleColumns) {
                printer.setColumnWidth(3, 0);
            }
        } else {
            for (int i = 0; i < this.columnWidths.size(); ++i) {
                Integer j = this.columnWidths.get(i);
                if (j == null) continue;
                printer.setColumnWidth(i + 1, j);
                if (!useMultipleColumns) continue;
                printer.setColumnWidth(i + 2 + this.columnWidths.size(), j);
            }
        }
        return new MenuImpl(this.app, this.title, this.prompt, this.inputPrompt, nbuilders, cbuilder, printer, callbacks, this.allowMultiSelect, this.defaultCallback, this.defaultDescription, this.defaultValidator, this.nMaxTries, this.useDefaultValidatorForDefaultInput, this.groupLabelPadding);
    }

    private void appendHeadings(TableBuilder builder, boolean useMultipleColumns) {
        builder.appendHeading();
        for (Message heading : this.columnHeadings) {
            if (heading != null) {
                builder.appendHeading(heading);
                continue;
            }
            builder.appendHeading();
        }
        if (useMultipleColumns) {
            builder.appendHeading();
            for (Message heading : this.columnHeadings) {
                if (heading != null) {
                    builder.appendHeading(heading);
                    continue;
                }
                builder.appendHeading();
            }
        }
    }

    public void setMaxTries(int nTries) {
        this.nMaxTries = nTries;
    }

    private Integer getMaxWidth(Collection<TableBuilder> builders, int columnIndex) {
        Integer maxWidth = null;
        for (TableBuilder builder : builders) {
            if (builder.getTableWidth() <= columnIndex) continue;
            Integer width = builder.getColumnWidth(columnIndex);
            if (maxWidth != null && (width == null || width <= maxWidth)) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private static final class ResultCallback<T>
    implements MenuCallback<T> {
        private final MenuResult<T> result;

        private ResultCallback(MenuResult<T> result) {
            this.result = result;
        }

        @Override
        public MenuResult<T> invoke(ConsoleInteraction app) throws CLIException {
            return this.result;
        }
    }

    private static final class MenuImpl<T>
    implements Menu<T> {
        private final boolean allowMultiSelect;
        private final ConsoleInteraction app;
        private final Map<String, MenuCallback<T>> callbacks;
        private final TableBuilder cBuilder;
        private final MenuCallback<T> defaultCallback;
        private final ValidationCallback<MenuCallback<T>> defaultValidator;
        private final Message defaultDescription;
        private final LinkedHashMap<Message, TableBuilder> nBuilders;
        private final TextTablePrinter printer;
        private final Message prompt;
        private final Message inputPrompt;
        private final Message title;
        private int nMaxTries;
        private boolean useDefaultValidatorForDefaultInput = true;
        private int groupLabelPadding = 1;
        private static final String EXTENDED_CALLBACK_KEYS = "/";

        private MenuImpl(ConsoleInteraction app, Message title, Message prompt, Message inputPrompt, LinkedHashMap<Message, TableBuilder> ntable, TableBuilder ctable, TextTablePrinter printer, Map<String, MenuCallback<T>> callbacks, boolean allowMultiSelect, MenuCallback<T> defaultCallback, Message defaultDescription, ValidationCallback<MenuCallback<T>> defaultValidator, int nMaxTries, boolean useDefaultValidatorForDefaultInput, int groupLabelPadding) {
            this.app = app;
            this.title = title;
            this.prompt = prompt;
            this.inputPrompt = inputPrompt;
            this.nBuilders = ntable;
            this.cBuilder = ctable;
            this.printer = printer;
            this.callbacks = callbacks;
            this.allowMultiSelect = allowMultiSelect;
            this.defaultCallback = defaultCallback;
            this.defaultDescription = defaultDescription;
            this.defaultValidator = defaultValidator;
            this.nMaxTries = nMaxTries;
            this.useDefaultValidatorForDefaultInput = useDefaultValidatorForDefaultInput;
            this.groupLabelPadding = groupLabelPadding;
        }

        @Override
        public MenuResult<T> run() throws CLIException {
            Message promptMsg;
            final String[] userInput = new String[]{""};
            ValidationCallback validator = new ValidationCallback<MenuCallback<T>>(){

                @Override
                public MenuCallback<T> validate(ConsoleInteraction app, String input) {
                    String firstChar = "";
                    userInput[0] = "";
                    if (input != null) {
                        userInput[0] = input.trim();
                        if (userInput[0].length() > 0) {
                            firstChar = Character.toString(userInput[0].charAt(0));
                        }
                    }
                    if (userInput[0].length() == 0) {
                        if (defaultCallback != null) {
                            if (defaultValidator == null || !useDefaultValidatorForDefaultInput) {
                                return defaultCallback;
                            }
                            try {
                                MenuResult result = defaultCallback.invoke(app);
                                if (result.isSuccess() && result.getValue() != null) {
                                    String value = result.getValue().toString();
                                    return (MenuCallback)defaultValidator.validate(app, value);
                                }
                                return defaultCallback;
                            }
                            catch (CLIException ce) {
                                return defaultCallback;
                            }
                        }
                        if (allowMultiSelect) {
                            app.println();
                            app.println(UBIDCommonMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                            app.println();
                            return null;
                        }
                        app.println();
                        app.println(UBIDCommonMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    if (allowMultiSelect) {
                        ArrayList cl = new ArrayList();
                        String[] stringArray = userInput[0].split(",");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            HashSet<String> choices = new HashSet<String>();
                            String value = stringArray[i];
                            String nvalue = value.trim();
                            if (choices.contains(nvalue)) {
                                app.println();
                                app.println(UBIDCommonMessages.ERR_MENU_BAD_CHOICE_MULTI_DUPE.get((Object)value));
                                app.println();
                                return null;
                            }
                            if (!callbacks.containsKey(nvalue)) {
                                app.println();
                                app.println(UBIDCommonMessages.ERR_MENU_BAD_CHOICE_MULTI.get());
                                app.println();
                                return null;
                            }
                            cl.add(callbacks.get(nvalue));
                            choices.add(nvalue);
                        }
                        return new CompositeCallback(cl);
                    }
                    if (callbacks.containsKey(userInput[0])) {
                        return (MenuCallback)callbacks.get(userInput[0]);
                    }
                    if (MenuImpl.EXTENDED_CALLBACK_KEYS.contains(firstChar) && callbacks.containsKey(firstChar)) {
                        return (MenuCallback)callbacks.get(firstChar);
                    }
                    if (defaultValidator == null) {
                        app.println();
                        app.println(UBIDCommonMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                        app.println();
                        return null;
                    }
                    try {
                        return (MenuCallback)defaultValidator.validate(app, userInput[0]);
                    }
                    catch (CLIException clie) {
                        return null;
                    }
                }
            };
            if (this.inputPrompt != null) {
                MessageBuilder mb = new MessageBuilder(this.inputPrompt);
                if (this.defaultDescription != null) {
                    mb.append((CharSequence)" [").append((CharSequence)this.defaultDescription).append(']');
                }
                mb.append((CharSequence)":");
                promptMsg = mb.toMessage();
            } else {
                promptMsg = this.allowMultiSelect ? (this.defaultDescription != null ? UBIDCommonMessages.INFO_MENU_PROMPT_MULTI_DEFAULT.get((Object)this.defaultDescription) : UBIDCommonMessages.INFO_MENU_PROMPT_MULTI.get()) : (this.defaultDescription != null ? UBIDCommonMessages.INFO_MENU_PROMPT_SINGLE_DEFAULT.get((Object)this.defaultDescription) : UBIDCommonMessages.INFO_MENU_PROMPT_SINGLE.get());
            }
            while (true) {
                MenuCallback choice;
                MenuResult result;
                if (this.title != null) {
                    this.app.println(this.title);
                    this.app.println();
                }
                if (this.prompt != null) {
                    this.app.println(this.prompt);
                    this.app.println();
                }
                int nItems = 0;
                for (Message group : this.nBuilders.keySet()) {
                    TableBuilder nbuilder = this.nBuilders.get(group);
                    if (nbuilder.getTableHeight() > 0 || nbuilder.hasHeader()) {
                        if (group != null) {
                            this.app.println(group, 2);
                            for (int i = 0; i < this.groupLabelPadding; ++i) {
                                this.app.println();
                            }
                        }
                        nbuilder.print(this.printer);
                        this.app.println();
                        this.printer.setDisplayHeadings(false);
                    }
                    nItems += nbuilder.getTableHeight();
                }
                if (this.cBuilder.getTableHeight() > 0) {
                    TextTablePrinter cprinter = new TextTablePrinter(this.app.getOutputStream());
                    cprinter.setDisplayHeadings(false);
                    int sz = String.valueOf(nItems).length() + 1;
                    cprinter.setIndentWidth(4);
                    cprinter.setColumnWidth(0, sz);
                    cprinter.setColumnWidth(1, 0);
                    this.cBuilder.print(cprinter);
                    this.app.println();
                }
                if (!(result = (choice = this.nMaxTries != -1 ? (MenuCallback)this.app.readValidatedInput(promptMsg, validator, this.nMaxTries) : (MenuCallback)this.app.readValidatedInput(promptMsg, null, validator)) instanceof TextualMenuCallback ? ((TextualMenuCallback)((Object)choice)).invoke(this.app, userInput[0]) : choice.invoke(this.app)).isAgain()) {
                    return result;
                }
                this.app.println();
                this.app.println();
            }
        }
    }

    private static final class CompositeCallback<T>
    implements MenuCallback<T> {
        private final Collection<MenuCallback<T>> callbacks;

        public CompositeCallback(Collection<MenuCallback<T>> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public MenuResult<T> invoke(ConsoleInteraction app) throws CLIException {
            ArrayList<T> values = new ArrayList<T>();
            for (MenuCallback<T> callback : this.callbacks) {
                MenuResult<T> result = callback.invoke(app);
                if (!result.isSuccess()) {
                    return result;
                }
                values.addAll(result.getValues());
            }
            return MenuResult.success(values);
        }
    }
}

