/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.SystemUtils;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.ValidationCallback;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PortValidationCallback
implements ValidationCallback<Integer> {
    private WarningMode warningMode = WarningMode.NONE;
    private String warnHost = null;
    private Set<Integer> unavailablePorts = null;

    public PortValidationCallback(WarningMode warningMode, String warnHost) {
        this.warningMode = warningMode;
        this.warnHost = warnHost;
    }

    public Set<Integer> getUnavailablePorts() {
        return this.unavailablePorts;
    }

    public void setUnavailablePorts(Set<Integer> unavailablePorts) {
        this.unavailablePorts = unavailablePorts;
    }

    public String getWarnHost() {
        return this.warnHost;
    }

    public void setWarnHost(String warnHost) {
        this.warnHost = warnHost;
    }

    @Override
    public Integer validate(ConsoleInteraction app, String input) throws CLIException {
        String ninput = input.trim();
        try {
            Integer port = Integer.parseInt(ninput);
            if (port < 1 || port > 65535) {
                throw new NumberFormatException();
            }
            if (this.unavailablePorts != null && this.unavailablePorts.contains(port)) {
                app.println();
                app.println(UBIDCommonMessages.ERR_UNAVAILABLE_PORT_NUMBER.get((Object)port));
                return null;
            }
            if (this.warningMode != WarningMode.NONE) {
                List<Message> messages = this.testPort(port);
                if (MessageUtils.containsError(messages)) {
                    port = null;
                }
                if (messages != null && !messages.isEmpty()) {
                    for (Message m : messages) {
                        app.println();
                        app.println(m);
                    }
                }
            }
            return port;
        }
        catch (NumberFormatException e) {
            app.println();
            app.println(UBIDCommonMessages.ERR_BAD_PORT_NUMBER.get((Object)ninput));
            return null;
        }
    }

    protected List<Message> testPort(int port) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.warningMode != WarningMode.NONE) {
            boolean inUse;
            if (this.warnHost == null) {
                this.warnHost = "localhost";
            }
            if ((inUse = SystemUtils.isPortInUse(this.warnHost, port)) && this.warningMode == WarningMode.IN_USE) {
                messages.add(UBIDCommonMessages.ERR_PORT_IN_USE_CONF.get((Object)port));
            } else if (!inUse && this.warningMode == WarningMode.NOT_IN_USE) {
                String address = this.warnHost + ":" + port;
                messages.add(UBIDCommonMessages.ERR_PORT_NOT_IN_USE_CONF.get((Object)address));
            }
        }
        return messages;
    }

    public static enum WarningMode {
        NONE,
        IN_USE,
        NOT_IN_USE;

    }
}

