/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli;

import com.unboundid.common.messages.UBIDCommonMessages;
import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.messages.Message;
import com.unboundid.messages.MessageBuilder;

public final class TaskOutputFormatter
extends ConsoleInteraction {
    private Message status;
    private ConsoleInteraction console;
    private int checkpoint;
    private boolean quiet;

    public TaskOutputFormatter(ConsoleInteraction console, Message status) {
        this.console = console;
        this.start(status);
    }

    public TaskOutputFormatter(ConsoleInteraction console) {
        this.console = console;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setStatus(Message status) {
        this.status = status;
    }

    public Message getStatus() {
        return this.status;
    }

    public void start(Message status) {
        this.start(status, false);
    }

    public void start(Message status, boolean suppressNewLine) {
        if (this.status != null) {
            this.done();
        } else if (!suppressNewLine && !this.quiet && this.checkpoint < this.console.getNumberOfErrorCharactersWritten()) {
            this.console.println();
        }
        this.status = status;
        this.printStatus();
        this.setStatusMode();
    }

    @Override
    public void println() {
        if (!this.quiet) {
            if (this.shouldPrintLineSeparator()) {
                this.console.println();
            }
            this.console.println();
        }
    }

    @Override
    public void println(Message output) {
        this.println(output, false);
    }

    public void println(Message output, boolean suppressNewline) {
        if (!this.quiet || output.isError() || output.isWarning()) {
            if (!this.quiet && !suppressNewline) {
                if (this.shouldPrintLineSeparator()) {
                    this.console.println();
                }
                this.console.println();
            }
            this.console.println(output);
        }
    }

    @Override
    public void print(Message output) {
        this.print(output, false);
    }

    public void print(Message output, boolean suppressNewline) {
        if (!this.quiet || output.isError() || output.isWarning()) {
            if (!this.quiet && !suppressNewline) {
                if (this.shouldPrintLineSeparator()) {
                    this.console.println();
                }
                this.console.println();
            }
            this.console.print(output);
        }
    }

    public void end(Message result) {
        if (this.status != null && !this.quiet) {
            if (this.checkpoint < this.console.getNumberOfErrorCharactersWritten()) {
                String last = this.console.getLastPrinted();
                if (last != null && !last.isEmpty() && last.charAt(last.length() - 1) != '\n') {
                    this.console.println();
                }
                this.console.println();
                this.printStatus();
            }
            this.console.println(result);
        }
        this.checkpoint = this.console.getNumberOfErrorCharactersWritten();
        this.status = null;
    }

    public boolean shouldPrintLineSeparator() {
        int charsWritten = this.console.getNumberOfErrorCharactersWritten();
        return charsWritten > 0 && charsWritten == this.checkpoint;
    }

    public void done() {
        this.end(UBIDCommonMessages.INFO_DONE.get());
    }

    public void error() {
        this.end(UBIDCommonMessages.INFO_ERROR.get());
    }

    @Override
    public boolean confirmAction(Message prompt, boolean defaultValue) throws CLIException {
        this.println();
        return this.console.confirmAction(prompt, defaultValue);
    }

    public void setStatusMode() {
        this.checkpoint = this.console.getNumberOfErrorCharactersWritten();
    }

    private void printStatus() {
        if (!this.quiet) {
            this.console.print(new MessageBuilder(this.status).append((CharSequence)" ..... ").toMessage());
        }
    }
}

