/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.table;

import com.unboundid.common.util.cli.table.TablePrinter;
import com.unboundid.common.util.cli.table.TableSerializer;
import com.unboundid.messages.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class TableBuilder {
    private int column = 0;
    private List<Integer> columnWidths = new ArrayList<Integer>();
    private List<Message> header = new ArrayList<Message>();
    private int height = 0;
    private List<List<String>> rows = new ArrayList<List<String>>();
    private List<Comparator<String>> sortComparators = new ArrayList<Comparator<String>>();
    private List<Integer> sortKeys = new ArrayList<Integer>();
    private int width = 0;
    private boolean sort = true;

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
    }

    public void addSortKey(int column) {
        this.addSortKey(column, String.CASE_INSENSITIVE_ORDER);
    }

    public void addSortKey(int column, Comparator<String> comparator) {
        this.sortKeys.add(column);
        this.sortComparators.add(comparator);
    }

    public void appendCell() {
        this.appendCell("");
    }

    public void appendCell(boolean value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(byte value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(char value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(double value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(float value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(int value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(long value) {
        this.appendCell(String.valueOf(value));
    }

    public void appendCell(Object value) {
        if (this.height == 0) {
            this.startRow();
        }
        String s = String.valueOf(value);
        this.rows.get(this.height - 1).add(s);
        ++this.column;
        int valueWidth = 0;
        if (s.contains("\n")) {
            for (String s1 : s.split("\n")) {
                valueWidth = Math.max(valueWidth, s1.length());
            }
        } else {
            valueWidth = s.length();
        }
        if (this.column > this.width) {
            this.width = this.column;
            this.columnWidths.add(valueWidth);
        } else if (this.columnWidths.get(this.column - 1) < valueWidth) {
            this.columnWidths.set(this.column - 1, valueWidth);
        }
    }

    public void appendHeading() {
        this.appendHeading(Message.EMPTY);
    }

    public void appendHeading(Message value) {
        this.header.add(value);
        int valueWidth = 0;
        String valueStr = value.toString();
        if (valueStr.contains("\n")) {
            for (String s1 : valueStr.split("\n")) {
                valueWidth = Math.max(valueWidth, s1.length());
            }
        } else {
            valueWidth = valueStr.length();
        }
        if (this.header.size() > this.width) {
            this.width = this.header.size();
            this.columnWidths.add(valueWidth);
        } else if (this.columnWidths.get(this.header.size() - 1) < valueWidth) {
            this.columnWidths.set(this.header.size() - 1, valueWidth);
        }
    }

    public boolean hasHeader() {
        return !this.header.isEmpty();
    }

    public int getRowWidth() {
        return this.column;
    }

    public int getTableHeight() {
        return this.height;
    }

    public Integer getColumnWidth(int column) {
        Integer width = null;
        if (column < this.columnWidths.size()) {
            width = this.columnWidths.get(column);
        }
        return width;
    }

    public void setColumnWidth(int column, int width) {
        if (column < this.columnWidths.size()) {
            this.columnWidths.set(column, width);
        }
    }

    public int getTableWidth() {
        return this.width;
    }

    public void print(TablePrinter printer) {
        TableSerializer serializer = printer.getSerializer();
        ArrayList<List<String>> sortedRows = new ArrayList<List<String>>(this.rows);
        if (this.sort) {
            Comparator<List<String>> comparator = new Comparator<List<String>>(){

                @Override
                public int compare(List<String> row1, List<String> row2) {
                    for (int i = 0; i < TableBuilder.this.sortKeys.size(); ++i) {
                        String cell1 = row1.get((Integer)TableBuilder.this.sortKeys.get(i));
                        String cell2 = row2.get((Integer)TableBuilder.this.sortKeys.get(i));
                        int rc = ((Comparator)TableBuilder.this.sortComparators.get(i)).compare(cell1, cell2);
                        if (rc == 0) continue;
                        return rc;
                    }
                    return 0;
                }
            };
            Collections.sort(sortedRows, comparator);
        }
        serializer.startTable(this.height, this.width);
        for (int i = 0; i < this.width; ++i) {
            serializer.addColumn(this.columnWidths.get(i));
        }
        serializer.startHeader();
        for (Message message : this.header) {
            serializer.addHeading(message.toString());
        }
        serializer.endHeader();
        serializer.startContent();
        for (List list : sortedRows) {
            serializer.startRow();
            for (int i = 0; i < this.width; ++i) {
                if (i < list.size()) {
                    serializer.addCell((String)list.get(i));
                    continue;
                }
                serializer.addCell("");
            }
            serializer.endRow();
        }
        serializer.endContent();
        serializer.endTable();
    }

    public void startRow() {
        this.rows.add(new ArrayList());
        ++this.height;
        this.column = 0;
    }
}

