/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.table;

import com.unboundid.common.util.cli.table.TablePrinter;
import com.unboundid.common.util.cli.table.TableSerializer;
import com.unboundid.common.util.tools.ToolConstants;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TextTablePrinter
extends TablePrinter {
    private static final String DEFAULT_COLUMN_SEPARATOR = "";
    private static final char DEFAULT_HEADING_SEPARATOR = '-';
    private static final int DEFAULT_PADDING = 1;
    private String columnSeparator = "";
    private boolean displayHeadings = true;
    private final Map<Integer, Integer> fixedColumns = new HashMap<Integer, Integer>();
    private int indentWidth = 0;
    private char headingSeparator = (char)45;
    private int headingSeparatorStartColumn = 0;
    private int padding = 1;
    private int totalWidth = ToolConstants.MAX_LINE_WIDTH;
    private boolean shrinkToFit;
    private final BitSet rightJustifiedColumns = new BitSet();
    private PrintWriter writer = null;

    public TextTablePrinter(OutputStream stream) {
        this(new BufferedWriter(new OutputStreamWriter(stream)));
    }

    public TextTablePrinter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setColumnWidth(int column, int width) throws IllegalArgumentException {
        if (column < 0) {
            throw new IllegalArgumentException("Negative column " + column);
        }
        if (width < 0) {
            throw new IllegalArgumentException("Negative width " + width);
        }
        this.fixedColumns.put(column, width);
    }

    public void setDisplayHeadings(boolean displayHeadings) {
        this.displayHeadings = displayHeadings;
    }

    public void setHeadingSeparator(char headingSeparator) {
        this.headingSeparator = headingSeparator;
    }

    public void setHeadingSeparatorStartColumn(int startColumn) {
        if (startColumn < 0) {
            throw new IllegalArgumentException("Negative start column " + startColumn);
        }
        this.headingSeparatorStartColumn = startColumn;
    }

    public void setIndentWidth(int indentWidth) throws IllegalArgumentException {
        if (indentWidth < 0) {
            throw new IllegalArgumentException("Negative indentation width " + indentWidth);
        }
        this.indentWidth = indentWidth;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setTotalWidth(int totalWidth) {
        this.totalWidth = totalWidth;
    }

    public void setShrinkToFit(boolean shrink) {
        this.shrinkToFit = shrink;
    }

    public void setRightJustified(int column) {
        this.rightJustifiedColumns.set(column);
    }

    public boolean isRightJustified(int column) {
        return this.rightJustifiedColumns.get(column);
    }

    @Override
    protected TableSerializer getSerializer() {
        return new Serializer();
    }

    private final class Serializer
    extends TableSerializer {
        private int column = 0;
        private final List<Integer> columnWidths = new ArrayList<Integer>();
        private final List<String> currentRow = new ArrayList<String>();
        private int totalColumns = 0;
        private final String indentPadding;

        private Serializer() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < TextTablePrinter.this.indentWidth; ++i) {
                builder.append(' ');
            }
            this.indentPadding = builder.toString();
        }

        @Override
        public void addCell(String s) {
            this.currentRow.add(s);
            ++this.column;
        }

        @Override
        public void addColumn(int width) {
            this.columnWidths.add(width);
            ++this.totalColumns;
        }

        @Override
        public void addHeading(String s) {
            if (TextTablePrinter.this.displayHeadings) {
                this.addCell(s);
            }
        }

        @Override
        public void endHeader() {
            if (TextTablePrinter.this.displayHeadings) {
                this.endRow();
                StringBuilder builder = new StringBuilder(this.indentPadding);
                for (int i = 0; i < this.totalColumns; ++i) {
                    int width = this.columnWidths.get(i);
                    if (this.totalColumns > 1) {
                        width = i == 0 || i == this.totalColumns - 1 ? (width += TextTablePrinter.this.padding) : (width += TextTablePrinter.this.padding * 2);
                    }
                    for (int j = 0; j < width; ++j) {
                        if (TextTablePrinter.this.headingSeparatorStartColumn > 0) {
                            if (i < TextTablePrinter.this.headingSeparatorStartColumn) {
                                builder.append(' ');
                                continue;
                            }
                            if (i == TextTablePrinter.this.headingSeparatorStartColumn && j < TextTablePrinter.this.padding) {
                                builder.append(' ');
                                continue;
                            }
                            builder.append(TextTablePrinter.this.headingSeparator);
                            continue;
                        }
                        builder.append(TextTablePrinter.this.headingSeparator);
                    }
                    if (i < TextTablePrinter.this.headingSeparatorStartColumn || i >= this.totalColumns - 1) continue;
                    builder.append(TextTablePrinter.this.columnSeparator);
                }
                TextTablePrinter.this.writer.println(builder.toString());
            }
        }

        @Override
        public void endRow() {
            boolean isRemainingText;
            do {
                StringBuilder builder = new StringBuilder(this.indentPadding);
                isRemainingText = false;
                for (int i = 0; i < this.currentRow.size(); ++i) {
                    int j;
                    String head;
                    int width = this.columnWidths.get(i);
                    String contents = this.currentRow.get(i);
                    String tail = null;
                    if (contents == null) {
                        head = TextTablePrinter.DEFAULT_COLUMN_SEPARATOR;
                    } else {
                        int maxConsider = Math.min(contents.length() - 1, width);
                        if (maxConsider >= 0 && contents.substring(0, maxConsider + 1).contains("\n")) {
                            int eolIndex = contents.indexOf("\n");
                            head = contents.substring(0, eolIndex).trim();
                            tail = contents.substring(eolIndex + 1);
                        } else if (contents.length() > width) {
                            int endIndex = contents.lastIndexOf(32, width);
                            if (endIndex == -1) {
                                endIndex = width;
                                head = contents.substring(0, endIndex);
                                tail = contents.substring(endIndex);
                            } else {
                                head = contents.substring(0, endIndex);
                                tail = contents.substring(endIndex + 1);
                            }
                        } else {
                            head = contents;
                        }
                    }
                    if (i > 0) {
                        for (j = 0; j < TextTablePrinter.this.padding; ++j) {
                            builder.append(' ');
                        }
                        builder.append(TextTablePrinter.this.columnSeparator);
                        for (j = 0; j < TextTablePrinter.this.padding; ++j) {
                            builder.append(' ');
                        }
                    }
                    if (TextTablePrinter.this.isRightJustified(i)) {
                        for (j = head.length(); j < width; ++j) {
                            builder.append(' ');
                        }
                    }
                    builder.append(head);
                    if (!TextTablePrinter.this.isRightJustified(i) && i != this.currentRow.size() - 1) {
                        for (j = head.length(); j < width; ++j) {
                            builder.append(' ');
                        }
                    }
                    this.currentRow.set(i, tail);
                    if (tail == null) continue;
                    isRemainingText = true;
                }
                TextTablePrinter.this.writer.println(builder.toString());
            } while (isRemainingText);
        }

        @Override
        public void endTable() {
            TextTablePrinter.this.writer.flush();
        }

        @Override
        public void startHeader() {
            this.determineColumnWidths();
            this.column = 0;
            this.currentRow.clear();
        }

        @Override
        public void startRow() {
            this.column = 0;
            this.currentRow.clear();
        }

        private void determineColumnWidths() {
            int available;
            int minWidth = TextTablePrinter.this.indentWidth;
            int expandableColumnSize = 0;
            for (int i = 0; i < this.totalColumns; ++i) {
                int actualSize = this.columnWidths.get(i);
                if (TextTablePrinter.this.fixedColumns.containsKey(i)) {
                    int requestedSize = (Integer)TextTablePrinter.this.fixedColumns.get(i);
                    if (requestedSize == 0) {
                        expandableColumnSize += actualSize;
                    } else {
                        this.columnWidths.set(i, requestedSize);
                        minWidth += requestedSize;
                    }
                } else if (TextTablePrinter.this.shrinkToFit && i == this.totalColumns - 1 && minWidth + actualSize + expandableColumnSize > TextTablePrinter.this.totalWidth) {
                    int shrunkenSize = TextTablePrinter.this.totalWidth - (minWidth + expandableColumnSize);
                    if (shrunkenSize > 0) {
                        this.columnWidths.set(i, shrunkenSize);
                        minWidth += shrunkenSize;
                    } else {
                        minWidth += actualSize;
                    }
                } else {
                    minWidth += actualSize;
                }
                if (i == this.totalColumns - 1) continue;
                minWidth += TextTablePrinter.this.padding * 2 + TextTablePrinter.this.columnSeparator.length();
            }
            if (minWidth < TextTablePrinter.this.totalWidth && expandableColumnSize > (available = TextTablePrinter.this.totalWidth - minWidth)) {
                for (int i = 0; i < this.totalColumns; ++i) {
                    int requestedSize;
                    int actualSize = this.columnWidths.get(i);
                    if (!TextTablePrinter.this.fixedColumns.containsKey(i) || (requestedSize = ((Integer)TextTablePrinter.this.fixedColumns.get(i)).intValue()) != 0 || (requestedSize = actualSize * available / expandableColumnSize) <= 10) continue;
                    this.columnWidths.set(i, requestedSize);
                }
            }
        }
    }
}

