/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.wizard;

import com.unboundid.common.util.cli.CLIException;
import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.MenuBuilder;
import com.unboundid.common.util.cli.MenuResult;
import com.unboundid.common.util.cli.wizard.WizardAction;
import com.unboundid.common.util.cli.wizard.WizardState;
import com.unboundid.common.util.cli.wizard.WizardStep;
import com.unboundid.messages.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractWizardStep<S extends WizardState>
implements WizardStep<S> {
    private static final String STEP_TITLE_PREFIX = ">>>>";
    private Message title;
    private WizardStep<S> parent;
    private List<WizardStep<S>> children = new ArrayList<WizardStep<S>>();
    protected ConsoleInteraction console;

    protected AbstractWizardStep(Message title, ConsoleInteraction console) {
        this.title = title;
        this.console = console;
    }

    @Override
    public Message getTitle(S state) {
        return this.title;
    }

    @Override
    public void setParent(WizardStep<S> parent) {
        this.parent = parent;
    }

    @Override
    public boolean reverse(S state) {
        return WizardAction.BACK.equals((Object)((WizardState)state).getPreviousAction());
    }

    @Override
    public WizardStep<S> getParent() {
        return this.parent;
    }

    @Override
    public final List<? extends WizardStep<S>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void beforeChildren(S state) {
    }

    @Override
    public WizardAction afterChildren(S state) throws CLIException {
        return ((WizardState)state).getPreviousAction();
    }

    protected WizardAction getActionFromMenuResult(MenuResult result, S state) throws CLIException {
        return this.getActionFromMenuResult(result, ((WizardState)state).getQuitWarning(), state);
    }

    WizardAction getActionFromMenuResult(MenuResult result, Message quitConfirm, S state) throws CLIException {
        WizardAction action = null;
        if (result.isQuit()) {
            action = quitConfirm == null || this.confirmAction(quitConfirm, false) ? WizardAction.END : WizardAction.REPEAT;
        } else if (result.isCancel()) {
            action = WizardAction.CANCEL;
        } else if (result.isBack()) {
            action = WizardAction.BACK;
        } else if (result.isFinish()) {
            action = WizardAction.NEXT;
        } else if (result.isSuccess()) {
            action = WizardAction.NEXT;
        }
        return action;
    }

    protected boolean confirmAction(Message prompt, boolean defaultValue) throws CLIException {
        this.console.println();
        return this.console.confirmAction(prompt, defaultValue);
    }

    protected void addStandardOptions(MenuBuilder<?> mb, WizardState state) {
        this.addStandardOptions(mb, state, true);
    }

    protected void addStandardOptions(MenuBuilder<?> mb, WizardState state, boolean allowBack) {
        if (allowBack && state.getController().getCurrentStepIndex() != 0) {
            mb.addBackOption(false);
        }
        mb.addQuitOption();
    }

    @Override
    public final WizardAction show(S state) throws CLIException {
        this.console.println();
        this.console.println();
        ArrayDeque<Message> titles = new ArrayDeque<Message>();
        Message stepTitle = this.getTitle(state);
        if (stepTitle == null) {
            throw new IllegalStateException("Step of type " + this.getClass().getName() + " returned a null title");
        }
        titles.push(stepTitle);
        for (WizardStep<S> p = this.getParent(); p != null; p = p.getParent()) {
            titles.push(p.getTitle(state));
        }
        String prefix = STEP_TITLE_PREFIX;
        for (Message title : titles) {
            this.console.print(Message.raw((CharSequence)prefix, (Object[])new Object[0]));
            this.console.print(Message.raw((CharSequence)" ", (Object[])new Object[0]));
            this.console.println(title);
            prefix = " " + prefix;
        }
        this.console.println();
        return this.internalShow(state);
    }

    public void addChild(WizardStep<S> child) {
        this.children.add(child);
        child.setParent(this);
    }

    protected abstract WizardAction internalShow(S var1) throws CLIException;

    protected void println() {
        this.console.println();
    }

    protected void println(Message message) {
        this.console.println(message);
    }

    protected String readInput(Message prompt, String defaultValue) throws CLIException {
        return this.console.readInput(prompt, defaultValue);
    }
}

