/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.common.util.cli.wizard;

import com.unboundid.common.util.cli.ConsoleInteraction;
import com.unboundid.common.util.cli.wizard.AbstractWizardStep;
import com.unboundid.common.util.cli.wizard.WizardAction;
import com.unboundid.common.util.cli.wizard.WizardState;
import com.unboundid.messages.Message;
import java.util.List;

public abstract class ListIteratingWizardStep<R, S extends WizardState>
extends AbstractWizardStep<S> {
    private int listIndex = -1;
    private boolean reverse;
    private List<R> list = null;

    protected ListIteratingWizardStep(Message title, ConsoleInteraction wizard) {
        super(title, wizard);
    }

    @Override
    public final void beforeChildren(S state) {
        if (this.list == null) {
            throw new IllegalStateException(this.getClass().getName() + " failed to call setList()");
        }
        if (((WizardState)state).getPreviousAction() == WizardAction.BACK) {
            this.listIndex = this.list.size() - 1;
        } else if (((WizardState)state).getPreviousAction() == WizardAction.NEXT) {
            this.listIndex = 0;
        }
        this.beforeChildrenInternal(state);
    }

    @Override
    public WizardAction afterChildren(S state) {
        WizardAction action = ((WizardState)state).getPreviousAction();
        this.setIndex(action);
        return this.processAction(action);
    }

    protected WizardAction processAction(WizardAction action) {
        if (action == WizardAction.END || action == WizardAction.CANCEL) {
            return action;
        }
        if (this.listIndex < 0) {
            this.reverse = false;
            return WizardAction.BACK;
        }
        if (this.listIndex == this.list.size()) {
            this.reverse = true;
            return WizardAction.NEXT;
        }
        if (action == WizardAction.BACK) {
            this.reverse = true;
        } else if (action == WizardAction.NEXT) {
            this.reverse = false;
        }
        return WizardAction.REPEAT;
    }

    protected void setIndex(WizardAction action) {
        if (action == WizardAction.BACK) {
            --this.listIndex;
        } else if (action == WizardAction.NEXT) {
            ++this.listIndex;
        }
    }

    protected void beforeChildrenInternal(S state) {
    }

    protected void setList(List<R> list, S state) {
        if (list == null) {
            throw new NullPointerException(this.getClass().getName() + " null list");
        }
        this.list = list;
        if (this.listIndex < 0 || this.listIndex >= list.size()) {
            this.listIndex = this.reverse(state) ? list.size() - 1 : 0;
        }
    }

    protected R getCurrentItem() {
        if (this.list != null && this.listIndex >= 0 && this.listIndex < this.list.size()) {
            return this.list.get(this.listIndex);
        }
        return null;
    }

    @Override
    public boolean reverse(S state) {
        return this.reverse;
    }

    protected boolean isFinished() {
        return this.listIndex >= this.list.size();
    }
}

