/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.pingdata;

import com.pingidentity.csd.server.util.LineTransformer;
import com.unboundid.directory.server.replication.common.ChangeNumber;
import com.unboundid.directory.server.util.TimeThread;
import com.unboundid.directory.server.util.TimeUtils;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PingDataLineTransformers {
    private static final int CSN_HEX_LEN = ChangeNumber.MINIMUM.toString().length();
    private static final Pattern CSN_HEX_PATTERN = Pattern.compile("\\b[0-9a-fA-F]{" + CSN_HEX_LEN + "}\\b");
    public static final LineTransformer csnDecoder = new LineTransformer(){

        @Override
        public String transform(String str) {
            Matcher m = CSN_HEX_PATTERN.matcher(str);
            StringBuffer buf = new StringBuffer();
            while (m.find()) {
                String changeNumberStr = m.group();
                ChangeNumber changeNumber = new ChangeNumber(changeNumberStr);
                m.appendReplacement(buf, changeNumberStr + " = {" + TimeThread.formatLocalTimeWithMs((Date)new Date(changeNumber.getTime())) + " (" + TimeUtils.durationToString((long)(System.currentTimeMillis() - changeNumber.getTime())) + " ago), Server ID: " + changeNumber.getServerID() + ", Sequence Number: " + changeNumber.getSeqnum() + "} ");
            }
            m.appendTail(buf);
            return buf.toString();
        }
    };

    private PingDataLineTransformers() {
        throw new UnsupportedOperationException(PingDataLineTransformers.class.getSimpleName() + " is a static utility class that should not be instantiated.");
    }
}

