/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.MessageDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.unboundid.messages.Message;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarManifestCollector
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private final File root;

    public JarManifestCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, File root) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        this.root = root;
    }

    public JarManifestCollector(CollectSupportData collectSupportData, MessageDataCollectorConfiguration messageDataCollectorConfiguration) {
        this(collectSupportData, messageDataCollectorConfiguration.getId(), messageDataCollectorConfiguration.getZipParentPathAsEnum(), messageDataCollectorConfiguration.getMessage(), new File(collectSupportData.getServerRoot()));
    }

    @Override
    protected void writeData() throws Exception {
        for (File jarFile : this.getLibJarFiles(this.root)) {
            this.writeln();
            try {
                JarFile jar = new JarFile(jarFile);
                Manifest manifest = jar.getManifest();
                Attributes attributes = manifest.getMainAttributes();
                this.writeln("Manifest for: " + jar.getName());
                for (Object key : attributes.keySet()) {
                    this.writeln("  " + key + ": " + attributes.get(key));
                }
            }
            catch (Throwable e) {
                this.writeln(e);
            }
            this.writeln();
        }
    }

    private Set<File> getLibJarFiles(File libDir) throws Exception {
        HashSet<File> jarFiles = new HashSet<File>();
        if (libDir.isDirectory()) {
            for (File child : libDir.listFiles()) {
                if (child.isDirectory()) {
                    jarFiles.addAll(this.getLibJarFiles(child));
                    continue;
                }
                if (!child.getName().toLowerCase().endsWith(".jar")) continue;
                jarFiles.add(child);
            }
        }
        return jarFiles;
    }
}

