/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.server.datacollector.config.LDAPSearchDataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.util.AdminSessionUtils;
import com.unboundid.csd.messages.QuickSetupMessages;
import com.unboundid.csd.messages.UBIDQuickSetupMessages;
import com.unboundid.csd.messages.UBIDToolMessages;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.messages.Message;
import java.util.Iterator;
import java.util.List;

public class LdapSearchDataCollector
extends DataCollectorTask {
    private CollectSupportData collectSupportData;
    private final SearchRequest searchRequest;
    private final LDAPInterface connection;
    private List<SearchResultEntry> foundEntries;
    private boolean isAdminSession;

    public LdapSearchDataCollector(CollectSupportData collectSupportData, String name, CollectSupportData.ZipParentPath zipParent, Message message, LDAPInterface connection, SearchRequest searchRequest, boolean isAdminSession) {
        super(collectSupportData, name, zipParent, message);
        this.collectSupportData = collectSupportData;
        this.searchRequest = searchRequest;
        this.connection = connection;
        this.isAdminSession = isAdminSession;
    }

    public LdapSearchDataCollector(CollectSupportData collectSupportData, LDAPSearchDataCollectorConfiguration ldapSearchDataCollectorConfiguration) {
        this(collectSupportData, ldapSearchDataCollectorConfiguration.getId(), ldapSearchDataCollectorConfiguration.getZipParentPathAsEnum(), ldapSearchDataCollectorConfiguration.getMessage(), collectSupportData.createLdapConnection(ldapSearchDataCollectorConfiguration.getCreateAdminSession()), ldapSearchDataCollectorConfiguration.getSearchRequest(), ldapSearchDataCollectorConfiguration.getCreateAdminSession());
    }

    public List<SearchResultEntry> getFoundEntries() {
        return this.foundEntries;
    }

    @Override
    protected void writeData() throws Exception {
        boolean noEntriesFound = false;
        if (this.connection != null && this.searchRequest != null) {
            try {
                this.collectSupportData.log("Search request " + this.searchRequest + " issued for " + this.getName());
                SearchResult res = this.connection.search(this.searchRequest);
                this.collectSupportData.log("Search result received for " + this.getName());
                this.foundEntries = res.getSearchEntries();
            }
            catch (LDAPException ldape) {
                if (ldape instanceof LDAPSearchException) {
                    this.foundEntries = ((LDAPSearchException)ldape).getSearchEntries();
                }
                if (this.foundEntries == null || ResultCode.NO_SUCH_OBJECT.equals((Object)ldape.getResultCode())) {
                    noEntriesFound = true;
                } else if (ResultCode.SIZE_LIMIT_EXCEEDED.equals((Object)ldape.getResultCode())) {
                    noEntriesFound = this.foundEntries.isEmpty();
                } else {
                    this.message = QuickSetupMessages.INFO_PROGRESS_ERROR.get();
                    this.collectSupportData.log("Error obtaining LDAP for data " + this.getName(), ldape);
                    this.collectSupportData.summaryMessages.add(UBIDToolMessages.ERR_SUPP_DATA_ERROR_LDAP.get());
                }
            }
            finally {
                if (this.foundEntries != null && this.foundEntries.size() > 0) {
                    Iterator<SearchResultEntry> iter = this.foundEntries.iterator();
                    while (iter.hasNext()) {
                        this.write(iter.next().toLDIFString());
                        if (!iter.hasNext()) continue;
                        this.write(CollectSupportData.EOL);
                    }
                    this.message = QuickSetupMessages.INFO_PROGRESS_DONE.get();
                } else {
                    noEntriesFound = true;
                }
            }
        }
        if (noEntriesFound) {
            this.message = UBIDQuickSetupMessages.INFO_NO_MATCHING_ENTRIES_FOUND.get();
            this.collectSupportData.log("Warning:  an LDAP search request " + this.searchRequest + " used to populate the zip file archive entry file '" + this.getName() + "' returned no entries.  This may indicate that the account specified as the value of --bindDN does not have access to this information or the expected entries have not yet been created.");
        }
        if (this.connection != null && this.isAdminSession && this.connection instanceof LDAPConnection) {
            AdminSessionUtils.endSession((LDAPConnection)this.connection);
        }
    }

    @Override
    public String getCommand() {
        return "ldapsearch";
    }
}

