/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task;

import com.pingidentity.csd.mon.util.Utils;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public abstract class SslDataCollector
extends DataCollectorTask {
    public SslDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
    }

    private SupportedCiphersResults runSupportedCiphersTest(String host, int port) {
        SupportedCiphersResults retval = new SupportedCiphersResults();
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{Utils.getTrustAllCertsTrustManager()}, null);
            String[] supportedCipherSuites = sslContext.getSupportedSSLParameters().getCipherSuites();
            retval.ciphersSupportedByTheClient = supportedCipherSuites;
            String[] supportedProtocols = sslContext.getSupportedSSLParameters().getProtocols();
            for (int i = 0; i < supportedCipherSuites.length; ++i) {
                for (int protocolCounter = 0; protocolCounter < supportedProtocols.length; ++protocolCounter) {
                    CipherTestResult testResultForThisCipher = new CipherTestResult();
                    testResultForThisCipher.cipher = supportedCipherSuites[i];
                    SSLSocket sock = (SSLSocket)sslContext.getSocketFactory().createSocket();
                    sock.setEnabledCipherSuites(new String[]{testResultForThisCipher.cipher});
                    if ("SSLv2Hello".equals(supportedProtocols[protocolCounter])) {
                        String lastItemInSupportedProtocols = supportedProtocols[supportedProtocols.length - 1];
                        sock.setEnabledProtocols(new String[]{supportedProtocols[protocolCounter], lastItemInSupportedProtocols});
                        testResultForThisCipher.protocol = supportedProtocols[protocolCounter];
                        testResultForThisCipher.secondaryProtocolForSSLv2Hello = lastItemInSupportedProtocols;
                    } else {
                        testResultForThisCipher.protocol = supportedProtocols[protocolCounter];
                        sock.setEnabledProtocols(new String[]{supportedProtocols[protocolCounter]});
                    }
                    sock.setUseClientMode(true);
                    try {
                        sock.connect(new InetSocketAddress(host, port), 3000);
                        sock.startHandshake();
                        testResultForThisCipher.negotiatedCipher = sock.getSession().getCipherSuite();
                        sock.close();
                        testResultForThisCipher.supported = true;
                    }
                    catch (Exception ex) {
                        testResultForThisCipher.exception = ex;
                    }
                    retval.results.add(testResultForThisCipher);
                }
            }
        }
        catch (Exception ex) {
            this.log("Unexpected error", ex);
            retval.exception = ex;
        }
        return retval;
    }

    private SupportedProtocolsResults runSupportedProtocolsTest(String host, int port) {
        SupportedProtocolsResults retval = new SupportedProtocolsResults();
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{Utils.getTrustAllCertsTrustManager()}, null);
            String[] supportedProtocols = sslContext.getSupportedSSLParameters().getProtocols();
            retval.protocolsSupportedByClient = supportedProtocols;
            this.log("Protocols supported by the client (this application): " + Arrays.asList(supportedProtocols));
            for (int i = 0; i < supportedProtocols.length; ++i) {
                SSLProtocolTestResult testResultForThisProtocol = new SSLProtocolTestResult();
                testResultForThisProtocol.protocol = supportedProtocols[i];
                SSLSocket sock = (SSLSocket)sslContext.getSocketFactory().createSocket();
                if ("SSLv2Hello".equals(supportedProtocols[i])) {
                    String lastItemInSupportedProtocols = supportedProtocols[supportedProtocols.length - 1];
                    sock.setEnabledProtocols(new String[]{supportedProtocols[i], lastItemInSupportedProtocols});
                    testResultForThisProtocol.secondaryProtocolForSSLv2Hello = lastItemInSupportedProtocols;
                } else {
                    sock.setEnabledProtocols(new String[]{supportedProtocols[i]});
                }
                sock.setUseClientMode(true);
                try {
                    long nanoTimeBeforeConnect = System.nanoTime();
                    sock.connect(new InetSocketAddress(host, port), 3000);
                    testResultForThisProtocol.connectTime = System.nanoTime() - nanoTimeBeforeConnect;
                    long nanoTimeBeforeHandshake = System.nanoTime();
                    sock.startHandshake();
                    testResultForThisProtocol.handshakeTime = System.nanoTime() - nanoTimeBeforeHandshake;
                    testResultForThisProtocol.selectedCipherSuite = sock.getSession().getCipherSuite();
                    Certificate[] peerCerts = sock.getSession().getPeerCertificates();
                    testResultForThisProtocol.peerCerts = peerCerts;
                    sock.close();
                    testResultForThisProtocol.supported = true;
                }
                catch (Exception ex) {
                    testResultForThisProtocol.exception = ex;
                }
                retval.protocolResults.add(testResultForThisProtocol);
            }
        }
        catch (Exception ex) {
            this.log("Unexpected error", ex);
            retval.exception = ex;
        }
        return retval;
    }

    public boolean collectDataForHostPort(String host, int port) throws Exception {
        this.writeln("<hostportresults host=\"" + XMLOutput.escapeXML(host) + "\" port=\"" + port + "\">");
        SupportedProtocolsResults protocolResults = this.runSupportedProtocolsTest(host, port);
        this.writeln("<protocols>");
        if (protocolResults.exception != null) {
            this.writeln("<exception>");
            this.writeln(XMLOutput.escapeXML(protocolResults.exception.getMessage()));
            this.writeln("</exception>");
        }
        this.writeln("<protocolsSupportedByClient>");
        this.writeln(XMLOutput.escapeXML("" + Arrays.asList(protocolResults.protocolsSupportedByClient)));
        this.writeln("</protocolsSupportedByClient>");
        this.writeln("<results>");
        if (protocolResults.protocolResults != null) {
            for (int i = 0; i < protocolResults.protocolResults.size(); ++i) {
                SSLProtocolTestResult resultForProt = protocolResults.protocolResults.get(i);
                this.writeln("\n<result>");
                this.writeln("<protocol>" + XMLOutput.escapeXML(resultForProt.protocol) + "</protocol>");
                this.writeln("<secondaryProtocolForSSLv2Hello>" + (resultForProt.secondaryProtocolForSSLv2Hello != null ? XMLOutput.escapeXML(resultForProt.secondaryProtocolForSSLv2Hello) : "") + "</secondaryProtocolForSSLv2Hello>");
                this.writeln("<selectedCipherSuite>" + (resultForProt.selectedCipherSuite != null ? XMLOutput.escapeXML(resultForProt.selectedCipherSuite) : "") + "</selectedCipherSuite>");
                this.writeln("<supported>" + resultForProt.supported + "</supported>");
                this.writeln("<handshakeTime>" + resultForProt.handshakeTime + "</handshakeTime>");
                this.writeln("<connectTime>" + resultForProt.connectTime + "</connectTime>");
                if (resultForProt.exception != null) {
                    this.writeln("<exception>");
                    this.writeln(XMLOutput.escapeXML(resultForProt.exception.getMessage()));
                    this.writeln("</exception>");
                }
                this.writeln("<peerCerts>");
                if (resultForProt.peerCerts != null) {
                    for (int certCounter = 0; certCounter < resultForProt.peerCerts.length; ++certCounter) {
                        this.writeln("<cert>");
                        this.writeln(XMLOutput.escapeXML(resultForProt.peerCerts[certCounter].toString()));
                        this.writeln("</cert>");
                    }
                }
                this.writeln("</peerCerts>");
                this.writeln("</result>");
            }
        }
        this.writeln("\n</results>");
        this.writeln("</protocols>");
        SupportedCiphersResults cipherTestResults = this.runSupportedCiphersTest(host, port);
        this.writeln("<ciphers>");
        if (cipherTestResults.exception != null) {
            this.writeln("<exception>");
            this.writeln(XMLOutput.escapeXML(cipherTestResults.exception.getMessage()));
            this.writeln("</exception>");
        }
        this.writeln("<ciphersSupportedByTheClient>");
        this.writeln(XMLOutput.escapeXML("" + Arrays.asList(cipherTestResults.ciphersSupportedByTheClient)));
        this.writeln("</ciphersSupportedByTheClient>");
        this.writeln("\n<results>");
        for (int i = 0; i < cipherTestResults.results.size(); ++i) {
            CipherTestResult cipherTestRes = cipherTestResults.results.get(i);
            this.writeln("<result>");
            this.writeln("<cipher>" + XMLOutput.escapeXML(cipherTestRes.cipher) + "</cipher>");
            this.writeln("<negotiatedCipher>" + (cipherTestRes.negotiatedCipher != null ? XMLOutput.escapeXML(cipherTestRes.negotiatedCipher) : "") + "</negotiatedCipher>");
            this.writeln("<protocol>" + XMLOutput.escapeXML(cipherTestRes.protocol) + "</protocol>");
            this.writeln("<secondaryProtocolForSSLv2Hello>" + (cipherTestRes.secondaryProtocolForSSLv2Hello != null ? XMLOutput.escapeXML(cipherTestRes.secondaryProtocolForSSLv2Hello) : "") + "</secondaryProtocolForSSLv2Hello>");
            this.writeln("<supported>" + cipherTestRes.supported + "</supported>");
            if (cipherTestRes.exception != null) {
                this.writeln("<exception>");
                String escapedStackTrace = XMLOutput.escapeXML(cipherTestRes.exception.getMessage());
                this.writeln(escapedStackTrace);
                this.writeln("</exception>");
            }
            this.writeln("</result>");
        }
        this.writeln("</results>");
        this.writeln("</ciphers>");
        this.writeln("</hostportresults>");
        return true;
    }

    private static class CipherTestResult {
        public String cipher;
        public String negotiatedCipher;
        public boolean supported;
        public String protocol;
        public String secondaryProtocolForSSLv2Hello;
        public Exception exception;

        private CipherTestResult() {
        }

        public String toString() {
            return "CipherTestResult={cipher:'" + this.cipher + "', negotiatedCipher='" + this.negotiatedCipher + "', supported='" + this.supported + "', protocol='" + this.protocol + "', secondaryProtocolForSSLv2Hello='" + (this.secondaryProtocolForSSLv2Hello != null ? this.secondaryProtocolForSSLv2Hello : "") + "', exception='" + (this.exception != null ? this.exception : "") + "'}";
        }
    }

    private static class SupportedCiphersResults {
        public List<CipherTestResult> results = new LinkedList<CipherTestResult>();
        public String[] ciphersSupportedByTheClient;
        public Exception exception;

        private SupportedCiphersResults() {
        }
    }

    private static class SupportedProtocolsResults {
        public String[] protocolsSupportedByClient;
        public Exception exception;
        public List<SSLProtocolTestResult> protocolResults = new LinkedList<SSLProtocolTestResult>();

        private SupportedProtocolsResults() {
        }

        public String toString() {
            return "SupportedProtocolsResults={protocolResults='" + this.protocolResults + "', exception='" + (this.exception != null ? this.exception : "") + "'}";
        }
    }

    private static class SSLProtocolTestResult {
        public String protocol;
        public String secondaryProtocolForSSLv2Hello;
        public boolean supported;
        public String selectedCipherSuite;
        public long connectTime;
        public long handshakeTime;
        public Certificate[] peerCerts;
        public Exception exception;

        private SSLProtocolTestResult() {
        }

        public String toString() {
            return "SSLProtocolTestResult={protocol='" + this.protocol + "', secondaryProtocolForSSLv2Hello='" + (this.secondaryProtocolForSSLv2Hello != null ? this.secondaryProtocolForSSLv2Hello : "") + "', selectedCipherSuite:'" + this.selectedCipherSuite + "', supported='" + this.supported + "',  connectTime='" + this.connectTime + "',  handshakeTime='" + this.handshakeTime + "',  exception='" + (this.exception != null ? this.exception : "") + "'}";
        }
    }
}

