/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pa;

import com.pingidentity.csd.mon.util.Utils;
import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.DataCollectorFileType;
import com.pingidentity.csd.server.datacollector.task.DataCollectorTask;
import com.pingidentity.csd.server.tools.CollectSupportData;
import com.pingidentity.csd.server.tools.XMLOutput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class PAHeartbeatDataCollector
extends DataCollectorTask {
    private String paBaseDir;
    private int numSamples = 5;
    private int intervalBetweenSamples = 1;

    public PAHeartbeatDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration.getId(), configuration.getZipParentPathAsEnum(), null, DataCollectorFileType.XML);
        this.paBaseDir = configuration.getStringParam("root");
        this.numSamples = configuration.getIntParam("numSamples");
        this.intervalBetweenSamples = configuration.getIntParam("intervalBetweenSamples");
    }

    @Override
    protected void writeData() throws Exception {
        this.collectData(this.paBaseDir);
    }

    public boolean collectData(String pathToProduct) throws Exception {
        this.writeln("<heartbeatresults>");
        HashSet allProcessedUrls = new HashSet();
        List<HeartbeatHostPortUrl> hostPortUrlsToBeTested = null;
        hostPortUrlsToBeTested = this.findPortsForPA(pathToProduct);
        if (hostPortUrlsToBeTested != null) {
            for (HeartbeatHostPortUrl hostPortUrl : hostPortUrlsToBeTested) {
                try {
                    this.collectDataInLoop(hostPortUrl.host, hostPortUrl.port, true, hostPortUrl.url, this.numSamples, this.intervalBetweenSamples);
                }
                catch (Exception ex) {
                    this.log("Error testing host='" + hostPortUrl.host + "' port='" + hostPortUrl.port + "' url='" + hostPortUrl.url + "'", ex);
                }
            }
        }
        this.writeln("</heartbeatresults>");
        return true;
    }

    private void collectDataInLoop(String host, int port, boolean isSSL, String url, int numberOfSamples, int intervalBetweenSamplesInSeconds) throws Exception {
        this.writeln("<service>");
        this.writeln("<host>" + host + "</host>");
        this.writeln("<port>" + port + "</port>");
        this.writeln("<isSSL>" + isSSL + "</isSSL>");
        this.writeln("<url>" + XMLOutput.escapeXML(url) + "</url>");
        this.writeln("<serviceresults>");
        for (int i = 0; i < numberOfSamples; ++i) {
            HeartbeatResult results = this.collectSample(host, port, url);
            this.write("<result>\r\n");
            this.write("<iteration>" + i + "</iteration>\r\n");
            if (results.exception != null) {
                this.write("<exception>" + XMLOutput.escapeXML(results.exception.toString()) + "</exception>\r\n");
            }
            this.write("<cipherSuite>" + XMLOutput.escapeXML(results.cipherSuite) + "</cipherSuite>\r\n");
            this.write("<request>" + XMLOutput.escapeXML(results.request) + "</request>\r\n");
            this.write("<response>" + XMLOutput.escapeXML(results.response) + "</response>\r\n");
            this.write("<sslProcotol>" + XMLOutput.escapeXML(results.sslProcotol) + "</sslProcotol>\r\n");
            this.write("<beginTimestamp>" + results.beginTimestamp + "</beginTimestamp>\r\n");
            this.write("<connectBeginTimestamp>" + results.connectBeginTimestamp + "</connectBeginTimestamp>\r\n");
            this.write("<connectEndTimestamp>" + results.connectEndTimestamp + "</connectEndTimestamp>\r\n");
            this.write("<connectTimeNanos>" + results.connectTimeNanos + "</connectTimeNanos>\r\n");
            this.write("<endTimestamp>" + results.endTimestamp + "</endTimestamp>\r\n");
            this.write("<handshakeBeginTimestamp>" + results.handshakeBeginTimestamp + "</handshakeBeginTimestamp>\r\n");
            this.write("<handshakeEndTimestamp>" + results.handshakeEndTimestamp + "</handshakeEndTimestamp>\r\n");
            this.write("<handshakeTimeNanos>" + results.handshakeTimeNanos + "</handshakeTimeNanos>\r\n");
            this.write("<readRequestBeginTimestamp>" + results.readRequestBeginTimestamp + "</readRequestBeginTimestamp>\r\n");
            this.write("<readRequestEndTimestamp>" + results.readRequestEndTimestamp + "</readRequestEndTimestamp>\r\n");
            this.write("<readRequestTime>" + results.readRequestTime + "</readRequestTime>\r\n");
            this.write("<writeRequestBeginTimestamp>" + results.writeRequestBeginTimestamp + "</writeRequestBeginTimestamp>\r\n");
            this.write("<writeRequestEndTimestamp>" + results.writeRequestEndTimestamp + "</writeRequestEndTimestamp>\r\n");
            this.write("<writeRequestTimeNanos>" + results.writeRequestTimeNanos + "</writeRequestTimeNanos>\r\n");
            if (results.peerCertificates != null) {
                this.write("<peerCertificates>");
                for (int certCounter = 0; certCounter < results.peerCertificates.length; ++certCounter) {
                    this.write("<certificate>");
                    if (results.peerCertificates[certCounter] instanceof X509Certificate) {
                        X509Certificate x509Cert = (X509Certificate)results.peerCertificates[certCounter];
                        this.write("<subject>" + XMLOutput.escapeXML("" + x509Cert.getSubjectX500Principal()) + "</subject>\r\n");
                        this.write("<serial>" + XMLOutput.escapeXML("" + x509Cert.getSerialNumber()) + "</serial>\r\n");
                        this.write("<issuer>" + XMLOutput.escapeXML("" + x509Cert.getIssuerX500Principal()) + "</issuer>\r\n");
                        this.write("<sigalg>" + XMLOutput.escapeXML("" + x509Cert.getSigAlgName()) + "</sigalg>\r\n");
                        this.write("<encoded>");
                        try {
                            this.write(XMLOutput.escapeXML(Utils.base64Encode(x509Cert.getEncoded())));
                        }
                        catch (CertificateEncodingException e) {
                            this.log("Error encoding peer certificate subject='" + x509Cert.getSubjectX500Principal() + "' serial='\"+x509Cert.getSerialNumber()'", e);
                        }
                        this.write("</encoded>");
                    } else {
                        this.write("<string>");
                        this.write(XMLOutput.escapeXML(results.peerCertificates[certCounter].toString()));
                        this.write("</string>");
                    }
                    this.write("</certificate>");
                }
                this.write("</peerCertificates>");
            }
            this.write("</result>\r\n");
            if (i + 1 < numberOfSamples) {
                this.log("Sleeping for " + intervalBetweenSamplesInSeconds + " seconds before the next heartbeat call");
            }
            try {
                Thread.currentThread();
                Thread.sleep(intervalBetweenSamplesInSeconds * 1000);
                continue;
            }
            catch (InterruptedException e) {
                this.log(" InterruptedException while sleeping between heartbeat calls");
                break;
            }
        }
        this.write("</serviceresults>\r\n");
        this.write("</service>\r\n");
    }

    public HeartbeatResult collectSample(String host, int port, String url) {
        if (url == null || url.isEmpty()) {
            this.log("Invalid heartbeat url: " + url);
            return null;
        }
        String scheme = url.substring(0, url.indexOf("://"));
        if ("https".equalsIgnoreCase(scheme)) {
            return this.collectSampleSSL(host, port, url);
        }
        return this.collectSampleNonSSL(host, port, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartbeatResult collectSampleSSL(String host, int port, String url) {
        HeartbeatResult result = new HeartbeatResult();
        Socket sock = null;
        try {
            String requestString;
            result.beginTimestamp = System.currentTimeMillis();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{Utils.getTrustAllCertsTrustManager()}, null);
            sock = (SSLSocket)sslContext.getSocketFactory().createSocket();
            ((SSLSocket)sock).setUseClientMode(true);
            sock.setSoTimeout(3000);
            long nanoTimeBeforeConnect = System.nanoTime();
            result.connectBeginTimestamp = System.currentTimeMillis();
            sock.connect(new InetSocketAddress(host, port), 3000);
            result.connectEndTimestamp = System.currentTimeMillis();
            result.connectTimeNanos = System.nanoTime() - nanoTimeBeforeConnect;
            result.handshakeBeginTimestamp = System.currentTimeMillis();
            long nanoTimeBeforeHandshake = System.nanoTime();
            ((SSLSocket)sock).startHandshake();
            result.handshakeTimeNanos = System.nanoTime() - nanoTimeBeforeHandshake;
            result.handshakeEndTimestamp = System.currentTimeMillis();
            result.isSSL = true;
            result.sslProcotol = ((SSLSocket)sock).getSession().getProtocol();
            result.cipherSuite = ((SSLSocket)sock).getSession().getCipherSuite();
            result.peerCertificates = ((SSLSocket)sock).getSession().getPeerCertificates();
            result.request = requestString = "GET " + url + " HTTP/1.1\r\nHost: " + host + "\r\nConnection: close\r\nAccept: */*\r\n\r\n";
            result.writeRequestBeginTimestamp = System.currentTimeMillis();
            long nanoTimeBeforeWritingRequest = System.nanoTime();
            sock.getOutputStream().write(requestString.getBytes());
            result.writeRequestTimeNanos = System.nanoTime() - nanoTimeBeforeWritingRequest;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int readResult = -1;
            byte[] byteBuffer = new byte[1024];
            result.readRequestBeginTimestamp = System.currentTimeMillis();
            long nanoTimeBeforeReadResponse = System.nanoTime();
            try {
                while ((readResult = sock.getInputStream().read(byteBuffer)) != -1) {
                    baos.write(byteBuffer, 0, readResult);
                }
            }
            catch (Exception readEx) {
                this.log("Error reading response", readEx);
            }
            result.readRequestTime = System.nanoTime() - nanoTimeBeforeReadResponse;
            result.readRequestEndTimestamp = System.currentTimeMillis();
            sock.close();
            result.response = baos.toString("UTF-8");
            result.endTimestamp = System.currentTimeMillis();
        }
        catch (Exception ex) {
            result.endTimestamp = System.currentTimeMillis();
            result.exception = ex;
            this.log("Error collecting sample from '" + url + "'", ex);
        }
        finally {
            if (sock != null && !sock.isClosed()) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    this.log("Error closing socket in finally", e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeartbeatResult collectSampleNonSSL(String host, int port, String url) {
        HeartbeatResult result = new HeartbeatResult();
        Socket sock = null;
        try {
            String requestString;
            result.beginTimestamp = System.currentTimeMillis();
            sock = SocketFactory.getDefault().createSocket();
            sock.setSoTimeout(3000);
            long nanoTimeBeforeConnect = System.nanoTime();
            result.connectBeginTimestamp = System.currentTimeMillis();
            sock.connect(new InetSocketAddress(host, port), 3000);
            result.connectEndTimestamp = System.currentTimeMillis();
            result.connectTimeNanos = System.nanoTime() - nanoTimeBeforeConnect;
            result.isSSL = false;
            result.request = requestString = "GET " + url + " HTTP/1.1\r\nHost: " + host + "\r\nConnection: close\r\nAccept: */*\r\n\r\n";
            result.writeRequestBeginTimestamp = System.currentTimeMillis();
            long nanoTimeBeforeWritingRequest = System.nanoTime();
            sock.getOutputStream().write(requestString.getBytes());
            result.writeRequestTimeNanos = System.nanoTime() - nanoTimeBeforeWritingRequest;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int readResult = -1;
            byte[] byteBuffer = new byte[1024];
            result.readRequestBeginTimestamp = System.currentTimeMillis();
            long nanoTimeBeforeReadResponse = System.nanoTime();
            try {
                while ((readResult = sock.getInputStream().read(byteBuffer)) != -1) {
                    baos.write(byteBuffer, 0, readResult);
                }
            }
            catch (Exception readEx) {
                this.log("Error reading response", readEx);
            }
            result.readRequestTime = System.nanoTime() - nanoTimeBeforeReadResponse;
            result.readRequestEndTimestamp = System.currentTimeMillis();
            sock.close();
            result.response = baos.toString("UTF-8");
            result.endTimestamp = System.currentTimeMillis();
        }
        catch (Exception ex) {
            result.endTimestamp = System.currentTimeMillis();
            result.exception = ex;
            this.log("Error collecting sample from '" + url + "'", ex);
        }
        finally {
            if (sock != null && !sock.isClosed()) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    this.log("Error closing socket in finally", e);
                }
            }
        }
        return result;
    }

    public List<HeartbeatHostPortUrl> findPortsForPA(String pathToProduct) {
        ArrayList<HeartbeatHostPortUrl> rv;
        block6: {
            rv = new ArrayList<HeartbeatHostPortUrl>();
            Properties runDotProps = new Properties();
            try {
                File runDotPropsFile = new File(pathToProduct + File.separator + "conf" + File.separator + "run.properties");
                FileInputStream runDotPropsInputStream = new FileInputStream(runDotPropsFile);
                runDotProps.load(runDotPropsInputStream);
                String paOperationalMode = runDotProps.getProperty("pa.operational.mode");
                if (!"CLUSTERED_CONSOLE".equals(paOperationalMode) && !"CLUSTERED_CONSOLE_REPLICA".equals(paOperationalMode) && !"STANDALONE".equals(paOperationalMode)) break block6;
                String paConsoleBindAddress = runDotProps.getProperty("admin.bindAddress");
                if (paConsoleBindAddress == null || paConsoleBindAddress.isEmpty() || "0.0.0.0".equals(paConsoleBindAddress) || "::".equals(paConsoleBindAddress)) {
                    paConsoleBindAddress = "127.0.0.1";
                }
                String paAdminHttpsPort = runDotProps.getProperty("admin.port");
                int adminPortNo = -1;
                try {
                    adminPortNo = Integer.parseInt(paAdminHttpsPort);
                    if (adminPortNo > -1) {
                        this.log("Collecting heartbeat data from PingAccess clustered console replica admin service " + paConsoleBindAddress + ":" + adminPortNo);
                        String url = this.createHeartbeatUrl(paConsoleBindAddress, adminPortNo, "/", true);
                        rv.add(new HeartbeatHostPortUrl(paConsoleBindAddress, adminPortNo, url));
                        break block6;
                    }
                    this.log("Not collecting heartbeat data from PingAccess admin service as it's disabled");
                }
                catch (Exception e) {
                    this.log("Error collecting data for PingAccess clustered console replica admin service '" + paAdminHttpsPort + "'", e);
                }
            }
            catch (Exception ex) {
                this.log("Unexpected error collecting heartbeat data for PingAccess", ex);
            }
        }
        return rv;
    }

    private String createHeartbeatUrl(String host, int port, String paContextPath, boolean isSSL) {
        StringBuilder url = new StringBuilder();
        if (isSSL) {
            url.append("https://");
        } else {
            url.append("http://");
        }
        url.append(host);
        url.append(":");
        url.append(port);
        url.append(paContextPath);
        if (!paContextPath.endsWith("/")) {
            url.append("/");
        }
        url.append("pa/heartbeat.ping");
        return url.toString();
    }

    public static class HeartbeatResult {
        public long beginTimestamp;
        public long connectTimeNanos;
        public long connectBeginTimestamp;
        public long connectEndTimestamp;
        public long handshakeTimeNanos;
        public long handshakeBeginTimestamp;
        public long handshakeEndTimestamp;
        public long writeRequestTimeNanos;
        public long writeRequestBeginTimestamp;
        public long writeRequestEndTimestamp;
        public long readRequestBeginTimestamp;
        public long readRequestEndTimestamp;
        public long readRequestTime;
        public long endTimestamp;
        public String response;
        public String request;
        public Exception exception;
        public String cipherSuite;
        public String sslProcotol;
        public Certificate[] peerCertificates;
        public boolean isSSL;

        public String nanoToSeconds(long nanoTime) {
            double seconds = (double)nanoTime / 1.0E9;
            return String.format("%.3f", seconds);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.request != null) {
                sb.append("========================");
                sb.append(System.lineSeparator());
                sb.append(this.request);
                sb.append(System.lineSeparator());
            }
            if (this.response != null) {
                sb.append(this.response);
                sb.append(System.lineSeparator());
            }
            sb.append("========================");
            sb.append(System.lineSeparator());
            sb.append("Statistics:");
            sb.append(System.lineSeparator());
            sb.append("  Begin timestamp : ");
            sb.append(new Date(this.beginTimestamp));
            sb.append(System.lineSeparator());
            sb.append("  Connect time : " + this.nanoToSeconds(this.connectTimeNanos) + " seconds");
            sb.append(System.lineSeparator());
            if (this.isSSL) {
                sb.append("  Handshake time : " + this.nanoToSeconds(this.handshakeTimeNanos) + " seconds");
                sb.append(System.lineSeparator());
            }
            sb.append("  Request time : " + this.nanoToSeconds(this.writeRequestTimeNanos) + " seconds");
            sb.append(System.lineSeparator());
            sb.append("  Response time : " + this.nanoToSeconds(this.readRequestTime) + " seconds");
            sb.append(System.lineSeparator());
            sb.append("  End timestamp : ");
            sb.append(new Date(this.endTimestamp));
            if (this.response != null) {
                sb.append(System.lineSeparator());
                sb.append("  Response length : ");
                sb.append(String.format("%,3d", this.response.length()));
            }
            if (this.isSSL) {
                sb.append(System.lineSeparator());
                sb.append("  Protocol : ");
                sb.append(this.sslProcotol);
                sb.append(System.lineSeparator());
                sb.append("  Cipher Suite : ");
                sb.append(this.cipherSuite);
                if (this.peerCertificates != null) {
                    for (int i = 0; i < this.peerCertificates.length; ++i) {
                        sb.append(System.lineSeparator());
                        sb.append("  Certificate [" + i + "] : ");
                        sb.append(System.lineSeparator());
                        if (this.peerCertificates[i] instanceof X509Certificate) {
                            X509Certificate x509Cert = (X509Certificate)this.peerCertificates[i];
                            sb.append("    Subject: " + x509Cert.getSubjectX500Principal());
                            sb.append(System.lineSeparator());
                            sb.append("    Serial: " + x509Cert.getSerialNumber().toString());
                            sb.append(System.lineSeparator());
                            sb.append("    Issuer: " + x509Cert.getIssuerX500Principal());
                            sb.append(System.lineSeparator());
                            sb.append("    Signature Algorithm: " + x509Cert.getSigAlgName());
                            sb.append(System.lineSeparator());
                            sb.append("    Valid From: " + x509Cert.getNotBefore());
                            sb.append(System.lineSeparator());
                            sb.append("    Valid Until: " + x509Cert.getNotAfter());
                        } else {
                            sb.append(this.peerCertificates[i].toString());
                        }
                        sb.append(System.lineSeparator());
                    }
                }
            }
            if (this.exception != null) {
                sb.append(System.lineSeparator());
                sb.append("  Exception : ");
                sb.append(System.lineSeparator());
                sb.append(this.exception.toString());
            }
            return sb.toString();
        }
    }

    private class HeartbeatHostPortUrl {
        public String host;
        public int port;
        public String url;

        public HeartbeatHostPortUrl(String urlString) {
            try {
                this.url = urlString;
                URL urlObj = new URL(urlString);
                this.host = urlObj.getHost();
                this.port = urlObj.getPort();
                if (this.port == -1) {
                    this.port = urlObj.getDefaultPort();
                }
            }
            catch (Exception ex) {
                PAHeartbeatDataCollector.this.log(urlString + " is not a valid URL");
            }
        }

        public HeartbeatHostPortUrl(String host, int port, String url) {
            this.host = host;
            this.port = port;
            this.url = url;
        }
    }
}

