/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.datacollector.task.pa;

import com.pingidentity.csd.server.datacollector.config.DataCollectorConfiguration;
import com.pingidentity.csd.server.datacollector.task.SslDataCollector;
import com.pingidentity.csd.server.tools.CollectSupportData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;

public class PASslDataCollector
extends SslDataCollector {
    private String paBaseDir;

    public PASslDataCollector(CollectSupportData collectSupportData, DataCollectorConfiguration configuration) {
        super(collectSupportData, configuration);
        this.paBaseDir = configuration.getStringParam("root");
    }

    @Override
    protected void writeData() throws Exception {
        block22: {
            this.writeln("<ssltestresults>");
            HashSet<String> allProcessedPortNumbers = new HashSet<String>();
            Properties runDotProps = new Properties();
            try {
                String paAgentPortEnabled;
                File runDotPropsFile = new File(this.paBaseDir + File.separator + "conf" + File.separator + "run.properties");
                FileInputStream runDotPropsInputStream = new FileInputStream(runDotPropsFile);
                runDotProps.load(runDotPropsInputStream);
                String paOperationalMode = runDotProps.getProperty("pa.operational.mode");
                if ("STANDALONE".equals(paOperationalMode) || "CLUSTERED_CONSOLE".equals(paOperationalMode)) {
                    String paConsoleBindAddress = runDotProps.getProperty("admin.bindAddress");
                    if (paConsoleBindAddress == null || paConsoleBindAddress.isEmpty() || "0.0.0.0".equals(paConsoleBindAddress) || "::".equals(paConsoleBindAddress)) {
                        paConsoleBindAddress = "127.0.0.1";
                    }
                    String paAdminHttpsPort = runDotProps.getProperty("admin.port");
                    int adminPortNo = -1;
                    try {
                        adminPortNo = Integer.parseInt(paAdminHttpsPort);
                        if (adminPortNo > -1) {
                            this.log("Collecting SSL/TLS data from PingAccess admin service " + paConsoleBindAddress + ":" + adminPortNo);
                            allProcessedPortNumbers.add(paConsoleBindAddress + ":" + adminPortNo);
                            this.collectDataForHostPort(paConsoleBindAddress, adminPortNo);
                        } else {
                            this.log("Not collecting SSL/TLS data from PingAccess admin service as it's disabled");
                        }
                    }
                    catch (Exception e) {
                        this.log("Error collecting data for PingAccess admin console port '" + paAdminHttpsPort + "'", e);
                    }
                }
                if ("CLUSTERED_CONSOLE".equals(paOperationalMode) || "CLUSTERED_CONSOLE_REPLICA".equals(paOperationalMode)) {
                    String paClusterConfigIsHttps = runDotProps.getProperty("clusterconfig.secure");
                    if (!"true".equals(paClusterConfigIsHttps)) {
                        this.log("Not collecting SSL/TLS data from PingAccess cluster config service as it's not secure(https)");
                    } else {
                        String paClusterConfigBindAddress = runDotProps.getProperty("clusterconfig.bindAddress");
                        if (paClusterConfigBindAddress == null || paClusterConfigBindAddress.isEmpty() || "0.0.0.0".equals(paClusterConfigBindAddress) || "::".equals(paClusterConfigBindAddress)) {
                            paClusterConfigBindAddress = "127.0.0.1";
                        }
                        String paClusterConfigHttpsPort = runDotProps.getProperty("admin.port");
                        int clusterConfigPortNo = -1;
                        try {
                            clusterConfigPortNo = Integer.parseInt(paClusterConfigHttpsPort);
                            if (clusterConfigPortNo > -1) {
                                this.log("Collecting SSL/TLS data from PingAccess cluster config service " + paClusterConfigBindAddress + ":clusterConfigPortNo");
                                allProcessedPortNumbers.add(paClusterConfigBindAddress + ":" + clusterConfigPortNo);
                                this.collectDataForHostPort(paClusterConfigBindAddress, clusterConfigPortNo);
                            } else {
                                this.log("Not collecting SSL/TLS data from PingAccess cluster config service as it's disabled");
                            }
                        }
                        catch (Exception e) {
                            this.log("Error collecting data for PingAccess cluster config port '" + clusterConfigPortNo + "'");
                        }
                    }
                }
                if ("true".equals(paAgentPortEnabled = runDotProps.getProperty("agent.http.enabled"))) {
                    String paAgentIsHttps = runDotProps.getProperty("agent.http.secure");
                    if (!"true".equals(paAgentIsHttps)) {
                        this.log("Not collecting SSL/TLS data from PingAccess agent service as it's not secure(https)");
                        break block22;
                    }
                    String paAgentBindAddress = runDotProps.getProperty("agent.http.bindAddress");
                    if (paAgentBindAddress == null || paAgentBindAddress.isEmpty() || "0.0.0.0".equals(paAgentBindAddress) || "::".equals(paAgentBindAddress)) {
                        paAgentBindAddress = "127.0.0.1";
                    }
                    String paAgentHttpsPort = runDotProps.getProperty("agent.http.port");
                    int agentPortNo = -1;
                    try {
                        agentPortNo = Integer.parseInt(paAgentHttpsPort);
                        if (agentPortNo > -1) {
                            this.log("Collecting SSL/TLS data from PingAccess agent service " + paAgentBindAddress + ":" + agentPortNo);
                            allProcessedPortNumbers.add(paAgentBindAddress + ":" + agentPortNo);
                            this.collectDataForHostPort(paAgentBindAddress, agentPortNo);
                            break block22;
                        }
                        this.log("Not collecting SSL/TLS data from PingAccess agent service as it's disabled");
                    }
                    catch (Exception e) {
                        this.log("Error collecting data for PingAccess agent console port '" + paAgentHttpsPort + "'");
                    }
                    break block22;
                }
                this.log("PingAccess agent port is disabled, skipping.");
            }
            catch (IOException e) {
                this.log("Unexpected error collecting ssl/tls data for PingAccess", e);
            }
        }
        this.writeln("</ssltestresults>");
    }
}

