/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import com.pingidentity.csd.server.tools.OperatingSystemVersion;
import com.pingidentity.csd.server.types.OperatingSystem;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum Command {
    JPS("jps", false, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS),
    JSTACK("jstack", false, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS),
    JSTAT("jstat", false, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS),
    JINFO("jinfo", false, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS),
    JMAP("jmap", false, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS),
    TAIL("tail", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    UNAME("uname", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    PS("ps", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    DF("df", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    CAT("cat", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    NETSTAT("netstat", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.WINDOWS, OperatingSystem.MACOS, OperatingSystem.AIX),
    IFCONFIG("ifconfig", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    UPTIME("uptime", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    LS("ls", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    SH("sh", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    CRONTAB("crontab", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.MACOS, OperatingSystem.AIX),
    DMESG("dmesg", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX),
    VMSTAT("vmstat", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.AIX),
    IOSTAT("iostat", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.AIX),
    MPSTAT("mpstat", true, OperatingSystem.SOLARIS, OperatingSystem.LINUX, OperatingSystem.AIX),
    ZONENAME("zonename", true, OperatingSystem.SOLARIS),
    ZONEADM("zoneadm", true, OperatingSystem.SOLARIS),
    ZFS("zfs", true, OperatingSystem.SOLARIS),
    ZPOOL("zpool", true, OperatingSystem.SOLARIS),
    FMDUMP("fmdump", true, OperatingSystem.SOLARIS),
    PRTCONF("prtconf", true, OperatingSystem.SOLARIS, OperatingSystem.AIX),
    SYSDEF("sysdef", true, OperatingSystem.SOLARIS),
    PRTDIAG("prtdiag", true, OperatingSystem.SOLARIS),
    PSRINFO("psrinfo", true, OperatingSystem.SOLARIS),
    PATCHADD("patchadd", true, Command.os(OperatingSystem.SOLARIS, "<5.11")),
    PKG("pkg", true, Command.os(OperatingSystem.SOLARIS, ">=5.11")),
    PRSTAT("prstat", true, OperatingSystem.SOLARIS),
    SMBIOS("smbios", true, OperatingSystem.SOLARIS),
    PMAP("pmap", true, OperatingSystem.LINUX),
    PSTACK("pstack", false, OperatingSystem.LINUX),
    GSTACK("gstack", false, OperatingSystem.LINUX),
    TOP("top", true, OperatingSystem.LINUX),
    SYSCTL("sysctl", true, OperatingSystem.LINUX),
    UDEVADM("udevadm", true, OperatingSystem.LINUX),
    SAR("sar", true, OperatingSystem.LINUX),
    DSTAT("dstat", true, OperatingSystem.LINUX),
    ETHTOOL("ethtool", false, OperatingSystem.LINUX),
    PIDSTAT("pidstat", true, OperatingSystem.LINUX),
    IP("ip", false, OperatingSystem.LINUX),
    SS("ss", false, OperatingSystem.LINUX),
    TUNEDADM("tuned-adm", false, OperatingSystem.LINUX),
    JOURNALCTL("journalctl", false, OperatingSystem.LINUX),
    SYSTEMCTL("systemctl", false, OperatingSystem.LINUX),
    CMD("cmd", true, OperatingSystem.WINDOWS),
    CACLS("cacls", true, OperatingSystem.WINDOWS),
    WMIC("wmic", true, OperatingSystem.WINDOWS),
    TYPE("type", true, OperatingSystem.WINDOWS),
    SYSTEM_PROFILER("system_profiler", true, OperatingSystem.MACOS),
    VM_STAT("vm_stat", true, OperatingSystem.MACOS),
    SAMPLE("sample", true, OperatingSystem.MACOS),
    RM("rm", true, OperatingSystem.MACOS),
    ALOG("alog", true, OperatingSystem.AIX),
    LPARSTAT("lparstat", true, OperatingSystem.AIX),
    VMO("vmo", true, OperatingSystem.AIX);

    protected static String internalToolName;
    private String name;
    private boolean expectInSystemPath;
    private List<OperatingSystemVersion> OSVs;

    public static Set<Command> forOs(OperatingSystem os, String version) {
        HashSet<Command> s = new HashSet<Command>();
        for (Command command : EnumSet.allOf(Command.class)) {
            if (!command.isCompatibleWith(os, version)) continue;
            s.add(command);
        }
        return s;
    }

    public static Set<Command> forThisOs() {
        return Command.forOs(OperatingSystem.local(), System.getProperty("os.version"));
    }

    public static OperatingSystemVersion os(OperatingSystem operatingSystem, String ... vrs) {
        return new OperatingSystemVersion(operatingSystem, vrs);
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpectedInSystemPath() {
        return this.expectInSystemPath;
    }

    private Command(String name, boolean expectInSystemPath, OperatingSystem ... os) {
        this.name = name;
        this.expectInSystemPath = expectInSystemPath;
        if (os == null) {
            throw new NullPointerException("Null OS list");
        }
        this.OSVs = new ArrayList<OperatingSystemVersion>(os.length);
        for (OperatingSystem operatingSystem : os) {
            this.OSVs.add(new OperatingSystemVersion(operatingSystem));
        }
    }

    private Command(String name, boolean expectInSystemPath, OperatingSystemVersion ... osVersions) {
        this.name = name;
        this.expectInSystemPath = expectInSystemPath;
        if (osVersions == null) {
            throw new NullPointerException("Null OS list");
        }
        this.OSVs = new ArrayList<OperatingSystemVersion>(osVersions.length);
        for (OperatingSystemVersion operatingSystemVersion : osVersions) {
            this.OSVs.add(operatingSystemVersion);
        }
    }

    public boolean isCompatibleWith(OperatingSystem os, String version) {
        for (OperatingSystemVersion osv : this.OSVs) {
            if (!osv.includes(os, version)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    static {
        internalToolName = "collect-support-data";
    }
}

