/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.tools;

import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private String id;
    private String type;
    private Map<String, String> configuration = new HashMap<String, String>();

    public Configuration() {
    }

    public Configuration(String id, String type, Map<String, String> configuration) {
        this.id = id;
        this.type = type;
        this.configuration = new HashMap<String, String>();
        this.configuration.putAll(configuration);
    }

    public Configuration(Configuration configuration) {
        this(configuration.getId(), configuration.getType(), configuration.getConfiguration());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public String getStringParam(String name) {
        return this.getConfiguration().get(name);
    }

    public Integer getIntParam(String name) {
        String o = this.getConfiguration().get(name);
        if (o instanceof Integer) {
            return (Integer)((Object)o);
        }
        try {
            return Integer.parseInt(o);
        }
        catch (ClassCastException | NumberFormatException e) {
            return null;
        }
    }

    public Boolean getBooleanParam(String name) {
        String o = this.getConfiguration().get(name);
        if (o instanceof Boolean) {
            return (Boolean)((Object)o);
        }
        return Boolean.parseBoolean(o);
    }

    public Boolean getBooleanParam(String name, boolean defaultValue) {
        String o = this.getConfiguration().get(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)((Object)o);
            }
            return Boolean.parseBoolean(o);
        }
        return defaultValue;
    }

    public boolean isValidConfiguration() {
        return true;
    }

    public String toString() {
        return this.getId() + ":" + this.getType();
    }
}

