/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.csd.server.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

abstract class LineOrientedOutputStream
extends OutputStream {
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(132);

    LineOrientedOutputStream() {
    }

    @Override
    public final void write(int cc) throws IOException {
        byte c = (byte)cc;
        this.buffer.write(cc);
        if (c == 10 || c == 13) {
            this.processBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
    }

    protected void processBuffer() throws IOException {
        try {
            this.processLine(this.buffer.toByteArray());
        }
        finally {
            this.buffer.reset();
        }
    }

    protected abstract void processLine(byte[] var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.processBuffer();
        }
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        int offset;
        int blockStartOffset = offset = off;
        int remaining = len;
        while (remaining > 0) {
            while (remaining > 0 && b[offset] != 10 && b[offset] != 13) {
                ++offset;
                --remaining;
            }
            int blockLength = offset - blockStartOffset;
            if (blockLength > 0) {
                this.buffer.write(b, blockStartOffset, blockLength);
            }
            while (remaining > 0 && (b[offset] == 10 || b[offset] == 13)) {
                this.write(b[offset]);
                ++offset;
                --remaining;
            }
            blockStartOffset = offset;
        }
    }
}

